#ifndef CRITICALSECTION_H
#define CRITICALSECTION_H

#include <windows.h>

class CriticalSection
{
public:
    CriticalSection()
    {
        InitializeCriticalSection(&m_cs);
    }

    ~CriticalSection()
    {
        DeleteCriticalSection(&m_cs);
    }

    void enter()
    {
        EnterCriticalSection(&m_cs);
    }

    void leave()
    {
        LeaveCriticalSection(&m_cs);
    }

private:
    CRITICAL_SECTION m_cs;
};

class CSLock
{
public:
    CSLock(CriticalSection& cs) :m_cs(cs)
    {
        m_cs.enter();
    }
    ~CSLock()
    {
        m_cs.leave();
    }
private:
    CriticalSection& m_cs;  
};

#endif