
#include "Linie.h"

///////////////////////////////////////////////////////////

Linie::Linie()
      :m_x1(0),  // Initialisierung
	   m_y1(0),  // mit Initialisierungsliste
       m_x2(0),
	   m_y2(0),
       m_farbe(RGB(10,10,10))
{
}

///////////////////////////////////////////////////////////

Linie::Linie(long x1, long y1,
             long x2, long y2)
      :m_x1(x1),  // Initialisierung
	   m_y1(y1),  // mit Initialisierungsliste
       m_x2(x2),
	   m_y2(y2),
       m_farbe(RGB(10,10,10))
{
}

///////////////////////////////////////////////////////////

void Linie::setzeFarbe(COLORREF farbe)
{
	m_farbe = farbe;

	if(m_linie != 0)
	{
		try
		{
			m_linie->Farbe = m_farbe;
		}
		catch(_com_error&)
		{
		}
	}
}

///////////////////////////////////////////////////////////

void Linie::setzeLinie(long x1, long y1,
                       long x2, long y2)
{
	m_x1 = x1;
	m_y1 = y1;
    m_x2 = x2;
    m_y2 = y2;

	if(m_linie != 0)
	{
		try
		{
			m_linie->X1 = m_x1;
			m_linie->Y1 = m_y1;
			m_linie->X2 = m_x2;
			m_linie->Y2 = m_y2;
		}
		catch(_com_error&)
		{
		}
	}
}

///////////////////////////////////////////////////////////

void Linie::setzePointer(const TSUZEICHNENLib::ILiniePtr& ptr)
{
	m_linie = ptr;

	if(m_linie != 0)
	{
		m_linie->Farbe = m_farbe;
		m_linie->X1 = m_x1;
		m_linie->Y1 = m_y1;
		m_linie->X2 = m_x2;
		m_linie->Y2 = m_y2;
	}
}

///////////////////////////////////////////////////////////

