#include "ObserverImpl.h"
#include <iostream>
#include <algorithm>
#include "Subject.h"

ObserverImpl::ObserverImpl()
{
    std::cout << "ObserverImpl created" << std::endl;
}

ObserverImpl::~ObserverImpl()
{
    // von allen Subjects "abmelden"
    Subjects::iterator it = _subjects.begin();
    Subjects::iterator end = _subjects.end();

    for( ; it != end; ++it)
    {
        Subject* theSubject = (*it);
        theSubject->unsubscribe(this);
    }

    std::cout << "ObserverImpl destroyed" << std::endl;
}

void ObserverImpl::update(Subject* theSubjectThatChanged,
                          Observer* observerThatUpdates)
{
    if(observerThatUpdates == this)
    {
        // Falls wir selber die
        // Aenderung verursachen interessiert
        // uns die update-Meldung nicht
        return;
    }

    // finden wir heraus welches Subject uns benachrichtigt
    Subjects::iterator it = std::find(_subjects.begin(), 
                                      _subjects.end(), 
                                      theSubjectThatChanged);
    int index = it - _subjects.begin();

    const Data& changedData = theSubjectThatChanged->getData();
    std::cout << "Data of Subject " << index;
    std::cout << " is now " << changedData << std::endl;
}

void ObserverImpl::observe(Subject* theSubjectToObserve)
{
    theSubjectToObserve->subscribe(this);
    _subjects.push_back(theSubjectToObserve);
}

