// Surface.h : Declaration of the CSurface

#ifndef __SURFACE_H_
#define __SURFACE_H_

#include "resource.h"       // main symbols
#include <atlctl.h>

#include <list>

struct Line
{
    Line(long x1, long y1,
         long x2, long y2)
    {
        start.x = x1;
        start.y = y1;
        end.x = x2;
        end.y = y2;
    }

    POINT start;
    POINT end;
};

typedef std::list<Line> Lines;


/////////////////////////////////////////////////////////////////////////////
// CSurface
class ATL_NO_VTABLE CSurface : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CStockPropImpl<CSurface, ISurface, &IID_ISurface, &LIBID_DRAWSURFACELib>,
	public CComControl<CSurface>,
	public IPersistStreamInitImpl<CSurface>,
	public IOleControlImpl<CSurface>,
	public IOleObjectImpl<CSurface>,
	public IOleInPlaceActiveObjectImpl<CSurface>,
	public IViewObjectExImpl<CSurface>,
	public IOleInPlaceObjectWindowlessImpl<CSurface>,
	public IPersistStorageImpl<CSurface>,
	public ISpecifyPropertyPagesImpl<CSurface>,
	public IQuickActivateImpl<CSurface>,
	public IDataObjectImpl<CSurface>,
	public IProvideClassInfo2Impl<&CLSID_Surface, NULL, &LIBID_DRAWSURFACELib>,
	public CComCoClass<CSurface, &CLSID_Surface>
{
public:
	CSurface()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_SURFACE)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CSurface)
	COM_INTERFACE_ENTRY(ISurface)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CSurface)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	PROP_ENTRY("BackColor", DISPID_BACKCOLOR, CLSID_StockColorPage)
	PROP_ENTRY("Caption", DISPID_CAPTION, CLSID_NULL)
	PROP_ENTRY("ForeColor", DISPID_FORECOLOR, CLSID_StockColorPage)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CSurface)
	CHAIN_MSG_MAP(CComControl<CSurface>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// ISurface
public:
	STDMETHOD(Clear)();
	STDMETHOD(addLine)(/*[in]*/ long xFrom, /*[in]*/ long yFrom, /*[in]*/ long xTo, /*[in]*/ long yTo);
	STDMETHOD(get_Height)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Width)(/*[out, retval]*/ long *pVal);

	HRESULT OnDraw(ATL_DRAWINFO& di);

    OLE_COLOR m_clrBackColor;
	CComBSTR m_bstrCaption;
	OLE_COLOR m_clrForeColor;

private:
    Lines _lines;
};

#endif //__SURFACE_H_
