// Surface.cpp : Implementation of CSurface

#include "stdafx.h"
#include "DrawSurface.h"
#include "Surface.h"
#include <atlapp.h>
#include <atlgdi.h>

/////////////////////////////////////////////////////////////////////////////
// CSurface


STDMETHODIMP CSurface::get_Width(long *pVal)
{
    if(0 == pVal)
    {
        return E_POINTER;
    }

    *pVal = 1000;
	
	return S_OK;
}

STDMETHODIMP CSurface::get_Height(long *pVal)
{
    if(0 == pVal)
    {
        return E_POINTER;
    }

    *pVal = 1000;

	return S_OK;
}

STDMETHODIMP CSurface::addLine(long xFrom, long yFrom, long xTo, long yTo)
{
    Line newLine(xFrom, yFrom, xTo, yTo);

    _lines.push_back(newLine);

    FireViewChange();

	return S_OK;
}

HRESULT CSurface::OnDraw(ATL_DRAWINFO& di)
{
	RECT& rc = *(RECT*)di.prcBounds;

    COLORREF foreColor;
    COLORREF backColor;
    OleTranslateColor(m_clrForeColor, NULL, &foreColor);
    OleTranslateColor(m_clrBackColor, NULL, &backColor);
    
    CDCHandle dc(di.hdcDraw);

    CPen pen;
    pen.CreatePen(PS_SOLID, 1, foreColor);
    CBrush brush;
    brush.CreateSolidBrush(backColor);

    HPEN oldPen = dc.SelectPen(pen);
    HBRUSH oldBrush = dc.SelectBrush(brush);

	Rectangle(di.hdcDraw, rc.left, rc.top, rc.right, rc.bottom);

    SetTextColor(di.hdcDraw, foreColor);
    SetBkColor(dc, backColor);

    Lines::iterator linesIt;
    Lines::iterator linesEnd = _lines.end();

    for(linesIt = _lines.begin(); linesIt != linesEnd; ++linesIt)
    {
        POINT from;
        from.x = rc.left + linesIt->start.x * (rc.right-rc.left) / 1000;
        from.y = rc.bottom - linesIt->start.y * (rc.bottom-rc.top) / 1000;
        POINT to;
        to.x = rc.left + linesIt->end.x * (rc.right-rc.left) / 1000;
        to.y = rc.bottom - linesIt->end.y * (rc.bottom-rc.top) / 1000;
        dc.MoveTo(from);
        dc.LineTo(to);
    }

    LPWSTR pszText = (BSTR)m_bstrCaption;
	TextOutW(di.hdcDraw, 
		     rc.left + 10, 
		     rc.top + 10, 
		     pszText, 
		     lstrlenW(pszText));


    dc.SelectPen(oldPen);
    dc.SelectBrush(oldBrush);


	return S_OK;
}

STDMETHODIMP CSurface::Clear()
{
    _lines.clear();

    FireViewChange();

	return S_OK;
}
