
#ifndef SERIALPORT_H
#define SERIALPORT_H

#include <windows.h>

#pragma warning (disable : 4786)

#include <map>
#include <set>
#include "CriticalSection.h"

class SerialPort;

// Interface fr einen Observer
// fr den seriellen Port
class SerialPortObserver
{
    public:
        virtual void newSerialData(const SerialPort& serialPort, 
                                   unsigned char data) = 0;

};

typedef std::set<SerialPortObserver*> Observers;

typedef std::map<unsigned char, SerialPort> SerialPorts;

class SerialPort
{
    public:
        ~SerialPort();

        void addObserver(SerialPortObserver* observer);
        void removeObserver(SerialPortObserver* observer);
        unsigned char getPortNumber() const;

        static SerialPort& getSerialPort(unsigned char portNumber);

        unsigned char readByte();
        void writeByte(unsigned char data);

        friend SerialPorts;

    private:
        SerialPort();
        void open(unsigned char port);
        void close();
        // diese Funktion wird aufgerufen
        // solange sich Observer im set
        // befinden
        void readAndDispatch();

        static DWORD WINAPI readThread(LPVOID threadParam);

    private:
        HANDLE        m_readThread;
        HANDLE        m_handle;
        unsigned char m_portNumber;
        Observers     m_observers;
        CriticalSection m_cs;
};




#endif