#pragma warning (disable : 4786)
#include "SerialPort.h"
#include <string>
#include <sstream>
#include <map>

SerialPort::SerialPort()
:_handle(INVALID_HANDLE_VALUE)
{
}

SerialPort::~SerialPort()
{
    close();
}

void SerialPort::open(unsigned char portNumber)
{
    std::stringstream stream;
    long number = portNumber;
    stream << "COM" << number;

    std::string comPort = stream.str();

    _handle = CreateFile(comPort.c_str(),
               GENERIC_READ | GENERIC_WRITE,
               0,
               0,
               OPEN_EXISTING,
               FILE_ATTRIBUTE_NORMAL,
               0);

    if(INVALID_HANDLE_VALUE == _handle)
    {
        throw std::string("Konnte Port nicht ffnen");
    }
    else
    {
        COMMTIMEOUTS ct = { 0 };
        
        BOOL ok = SetCommTimeouts(_handle, &ct);

        if(FALSE == ok)
        {
            throw std::string("Konnte Timeouts nicht setzen");
        }

        DCB dcb = { 0 };
        ok = GetCommState(_handle, &dcb);
        
        if(FALSE == ok)
        {
            throw std::string("Konnte DCB nicht lesen");
        }

        dcb.BaudRate = CBR_9600;
        dcb.ByteSize = 8;
        dcb.Parity = NOPARITY;
        dcb.StopBits = ONESTOPBIT;

        ok = SetCommState(_handle, &dcb);

        if(FALSE == ok)
        {
            throw std::string("Konnte DCB nicht setzen");
        }
    }
}

void SerialPort::close()
{
    if(INVALID_HANDLE_VALUE != _handle)
    {
        CloseHandle(_handle);
        _handle = INVALID_HANDLE_VALUE;
    }
}

void SerialPort::writeByte(unsigned char data)
{
    if(INVALID_HANDLE_VALUE == _handle)
    {
        throw std::string("Port nicht offen");
    }

    DWORD bytesWritten = 0;
    BOOL result = FALSE;

    result = WriteFile(_handle, 
                      &data,
                      1,
                      &bytesWritten,
                      0);

    if(FALSE == result)
    {
        DWORD error = GetLastError();
        std::stringstream stream;
        stream << "WriteFile misslungen mit";
        stream << " error Code : " << error;
        throw stream.str();
    }

}

typedef std::map<unsigned char, SerialPort*> SerialPortsMap;

class SerialPorts : public SerialPortsMap
{
public:
    ~SerialPorts()
    {
        iterator it = begin();
        iterator endIt = end();

        for( ; it != endIt; ++it)
        {
            delete it->second;
        }
    }
};

SerialPort& SerialPort::getSerialPort(unsigned char portNumber)
{
    static SerialPorts serialPorts;

    SerialPorts::iterator it = serialPorts.find(portNumber);

    if(it != serialPorts.end())
    {
        SerialPort* gefundenes = it->second;
        return *gefundenes;
    }
    else
    {
        SerialPort* neues = new SerialPort;
        neues->open(portNumber);
        serialPorts[portNumber] = neues;
        return *neues;
    }
}
