// ZeichenFlaeche.h : Declaration of the ZeichenFlaeche

#ifndef __ZEICHENFLAECHE_H_
#define __ZEICHENFLAECHE_H_

#include "resource.h"       // main symbols
#include <atlmisc.h>
#include <set>
#include <comdef.h>
#include <atlgdi.h>

class Kreis;

/////////////////////////////////////////////////////////////////////////////
// ZeichenFlaeche
class ATL_NO_VTABLE ZeichenFlaeche : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<ZeichenFlaeche, &CLSID_ZeichenFlaeche>,
	public IDispatchImpl<IZeichenFlaeche, &IID_IZeichenFlaeche, &LIBID_TSUZEICHNENLib>,
    public CWindowImpl<ZeichenFlaeche>
{
    public:
	    ZeichenFlaeche();

        void FinalRelease();

	DECLARE_WND_CLASS(NULL)

    DECLARE_REGISTRY_RESOURCEID(IDR_ZEICHENFLAECHE)

    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(ZeichenFlaeche)
	    COM_INTERFACE_ENTRY(IZeichenFlaeche)
	    COM_INTERFACE_ENTRY(IDispatch)
    END_COM_MAP()

	BEGIN_MSG_MAP(CKreiseView)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
	END_MSG_MAP()

	LRESULT OnPaint(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);

    // IZeichenFlaeche
    public:
	    STDMETHOD(get_HintergrundBild)(/*[out, retval]*/ BSTR *pVal);
	    STDMETHOD(put_HintergrundBild)(/*[in]*/ BSTR newVal);
	    STDMETHOD(NeueLinie)(/*[out, retval]*/ILinie** pVal);
	    STDMETHOD(NeuerText)(/*[out, retval]*/ IText** pVal);
	    STDMETHOD(get_Farbe)(/*[out, retval]*/ OLE_COLOR *pVal);
	    STDMETHOD(put_Farbe)(/*[in]*/ OLE_COLOR newVal);
	    STDMETHOD(NeuerKreis)(/*[out, retval]*/ IKreis** pVal);
	    STDMETHOD(get_Name)(/*[out, retval]*/ BSTR *pVal);
	    STDMETHOD(get_Hoehe)(/*[out, retval]*/ long *pVal);
	    STDMETHOD(put_Hoehe)(/*[in]*/ long newVal);
	    STDMETHOD(get_Breite)(/*[out, retval]*/ long *pVal);
	    STDMETHOD(put_Breite)(/*[in]*/ long newVal);

    private:
        void create();
        void drawBitmap(CDC& dc, const RECT& rect);

    private:
        long		_breite;
        long		_hoehe;
		OLE_COLOR	_farbe;
        _bstr_t     _hintergrundBild;
        CBitmap     _bitmap;

		typedef std::set<Kreis*> Kreise;
		Kreise	_kreise;
		typedef std::set<Text*> Texte;
		Texte	_texte;
        typedef std::set<Linie*> Linien;
        Linien  _linien;
};

#endif //__ZEICHENFLAECHE_H_
