// ZeichenFlaeche.cpp : Implementation of ZeichenFlaeche
#include "stdafx.h"
#include "TsuZeichnen.h"
#include "ZeichenFlaeche.h"
#include "Kreis.h"
#include "Text.h"
#include "Linie.h"

/////////////////////////////////////////////////////////////////////////////
// ZeichenFlaeche

/////////////////////////////////////////////////////////////////////////////

ZeichenFlaeche::ZeichenFlaeche()
               :_breite(0),
                _hoehe(0),
				_farbe(RGB(20,20,20))
{
}

/////////////////////////////////////////////////////////////////////////////

void ZeichenFlaeche::FinalRelease()
{
	Kreise::iterator it = _kreise.begin();
	Kreise::iterator endIt = _kreise.end();

	for( ; it != endIt; ++it)
	{
		Kreis* kreis = *it;
		kreis->Release();
	}

	_kreise.clear();

	Texte::iterator itt = _texte.begin();
	Texte::iterator endItt = _texte.end();

	for( ; itt != endItt; ++itt)
	{
		Text* text = *itt;
		text->Release();
	}

	_texte.clear();
	
	if(IsWindow())
	{
		DestroyWindow();
	}
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::get_Breite(long *pVal)
{
    *pVal = _breite;

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::put_Breite(long newVal)
{
    _breite = newVal;

    if(0 == m_hWnd && _breite > 0 && _hoehe > 0)
    {
        create();
    }

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::get_Hoehe(long *pVal)
{
    *pVal = _hoehe;

    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::put_Hoehe(long newVal)
{
    _hoehe = newVal;

    if(0 == m_hWnd && _breite > 0 && _hoehe > 0)
    {
        create();
    }

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

LRESULT ZeichenFlaeche::OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	CPaintDC dc(m_hWnd);

	RECT rect;

	GetClientRect(&rect);

    if(_bitmap.IsNull())
    {
	    dc.FillSolidRect(&rect, _farbe);
    }
    else
    {
        drawBitmap(dc, rect);
    }

	Kreise::iterator it = _kreise.begin();
	Kreise::iterator endIt = _kreise.end();

	for( ; it != endIt; ++it)
	{
		Kreis* kreis = *it;
		kreis->draw(dc);
	}

	Texte::iterator itt = _texte.begin();
	Texte::iterator endItt = _texte.end();

	for( ; itt != endItt; ++itt)
	{
		Text* text = *itt;
		text->draw(dc);
	}

    Linien::iterator itl = _linien.begin();
    Linien::iterator endItl = _linien.end();

    for( ; itl != endItl; ++itl)
    {
        Linie* linie = *itl;
        linie->draw(dc);
    }

	return 0;
}

/////////////////////////////////////////////////////////////////////////////

void ZeichenFlaeche::create()
{
    ATLASSERT(0 == m_hWnd);

    CRect rect(0, 0, _breite, _hoehe);
    rect.OffsetRect(50, 50);

	//m_hWnd = Create(0, rect, _T("Zeichenflaeche"), WS_OVERLAPPEDWINDOW);
	//AnimateWindow(m_hWnd, 500, AW_BLEND);
    DWORD style = WS_VISIBLE  | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | 
                                 WS_MINIMIZEBOX | WS_MAXIMIZEBOX;
    
    BOOL adjustOK = AdjustWindowRect(&rect, style, FALSE);

    m_hWnd = Create(0, rect, _T("Zeichenflaeche"), style);
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::get_Name(BSTR *pVal)
{
    CComBSTR name(L"Zeichenflaeche");
    
    name.CopyTo(pVal);

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::NeuerKreis(IKreis **pVal)
{
	HRESULT hr = S_OK;

	CComObject<Kreis>* kreis;

	hr = CComObject<Kreis>::CreateInstance(&kreis);
	if(SUCCEEDED(hr))
	{
		kreis->setWnd(m_hWnd);
		hr = kreis->QueryInterface(pVal);
		_kreise.insert(kreis);
	}

	return hr;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::NeuerText(IText **pVal)
{
	HRESULT hr = S_OK;

	CComObject<Text>* text;

	hr = CComObject<Text>::CreateInstance(&text);
	if(SUCCEEDED(hr))
	{
		text->setWnd(m_hWnd);
		hr = text->QueryInterface(pVal);
		_texte.insert(text);
	}

	return hr;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::get_Farbe(OLE_COLOR *pVal)
{
	*pVal = _farbe;

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::put_Farbe(OLE_COLOR newVal)
{
	_farbe = newVal;

	Invalidate();

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////


STDMETHODIMP ZeichenFlaeche::NeueLinie(ILinie **pVal)
{
	HRESULT hr = S_OK;

	CComObject<Linie>* linie;

	hr = CComObject<Linie>::CreateInstance(&linie);
	if(SUCCEEDED(hr))
	{
		linie->setWnd(m_hWnd);
		hr = linie->QueryInterface(pVal);
		_linien.insert(linie);
	}

	return hr;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::get_HintergrundBild(BSTR *pVal)
{
    *pVal = _hintergrundBild.copy();
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP ZeichenFlaeche::put_HintergrundBild(BSTR newVal)
{
    HRESULT hr = E_FAIL;

    _hintergrundBild = _bstr_t(newVal);

    HANDLE hImage = LoadImage(0, 
                              _hintergrundBild, 
                              IMAGE_BITMAP, 
                              0, 
                              0, 
                              LR_LOADFROMFILE);

    if(hImage)
    {
        if(!_bitmap.IsNull())
        {
            _bitmap.DeleteObject();
        }
        _bitmap.Attach((HBITMAP)hImage);
        hr = S_OK;
    }
    else
    {
        hr = GetLastError();
    }

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

void ZeichenFlaeche::drawBitmap(CDC& dc, const RECT& rect)
{
    CDC cdc;
    cdc.CreateCompatibleDC(dc);

    CBitmap oldBitmap = cdc.SelectBitmap(_bitmap);
    CRect destRect(rect);
    SIZE bitmapSize;
    _bitmap.GetSize(bitmapSize);
    dc.StretchBlt(0,
                  0,
                  destRect.Width(), 
                  destRect.Height(), 
                  cdc, 
                  0, 
                  0, 
                  bitmapSize.cx, 
                  bitmapSize.cy, 
                  SRCCOPY);

}

/////////////////////////////////////////////////////////////////////////////
