// Text.cpp : Implementation of Text
#include "stdafx.h"
#include "TsuZeichnen.h"
#include "Text.h"

/////////////////////////////////////////////////////////////////////////////
// Text

Text::Text()
{
	InternalAddRef();
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Text::get_Farbe(OLE_COLOR *pVal)
{
	*pVal = _color;

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Text::put_Farbe(OLE_COLOR newVal)
{
	_color = newVal;

	if(_hwnd)
	{
		InvalidateRect(_hwnd, 0, TRUE);
	}

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Text::get_X(long *pVal)
{
	*pVal = _point.x;

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Text::put_X(long newVal)
{
	_point.x = newVal;

	if(_hwnd)
	{
		InvalidateRect(_hwnd, 0, TRUE);
	}

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Text::get_Y(long *pVal)
{
	*pVal = _point.y;

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Text::put_Y(long newVal)
{
	_point.y = newVal;

	if(_hwnd)
	{
		InvalidateRect(_hwnd, 0, TRUE);
	}

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Text::get_Inhalt(BSTR *pVal)
{
	*pVal = _inhalt.copy();

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Text::put_Inhalt(BSTR newVal)
{
	_bstr_t newText(newVal);

	_inhalt = newText;

	if(_hwnd)
	{
		InvalidateRect(_hwnd, 0, TRUE);
	}

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

void Text::draw(CDC& dc)
{
	UINT oldTA = dc.SetTextAlign(TA_CENTER | TA_BASELINE);
	COLORREF oldTC = dc.SetTextColor(_color);
	int oldMode = dc.SetBkMode(TRANSPARENT);

	dc.TextOut(_point.x, _point.y + 4, (LPCTSTR)_inhalt);
	
	dc.SetBkMode(oldMode);
	dc.SetTextColor(oldTC);
	dc.SetTextAlign(oldTA);
}

/////////////////////////////////////////////////////////////////////////////
