// Kreis.cpp : Implementation of Kreis
#include "stdafx.h"
#include "TsuZeichnen.h"
#include "Kreis.h"

/////////////////////////////////////////////////////////////////////////////
// Kreis

/////////////////////////////////////////////////////////////////////////////
// Kreis

Kreis::Kreis()
      :_color(RGB(20,20,20)),
       _point(0,0),
       _radius(0)
{
	InternalAddRef();
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Kreis::get_Radius(long *pVal)
{
    *pVal = _radius;
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Kreis::put_Radius(long newVal)
{
    _radius = newVal;

	if(_hwnd)
	{
		InvalidateRect(_hwnd, 0, TRUE);
	}

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Kreis::get_Farbe(OLE_COLOR *pVal)
{
    *pVal = _color;
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Kreis::put_Farbe(OLE_COLOR newVal)
{
    _color = newVal;

	if(_hwnd)
	{
		InvalidateRect(_hwnd, 0, TRUE);
	}

    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Kreis::get_X(long *pVal)
{
    *pVal = _point.x;

    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Kreis::put_X(long newVal)
{
    _point.x = newVal;
    
 	if(_hwnd)
	{
		InvalidateRect(_hwnd, 0, TRUE);
	}

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Kreis::get_Y(long *pVal)
{
    *pVal = _point.y;
	
    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

STDMETHODIMP Kreis::put_Y(long newVal)
{
    _point.y = newVal;
    
	if(_hwnd)
	{
		InvalidateRect(_hwnd, 0, TRUE);
	}

    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////

void Kreis::draw(CDC& dc)
{
    COLORREF brushColor;

    if(SUCCEEDED(OleTranslateColor(_color, 0, &brushColor)))
    {
        // Brush used to fill area
        CBrush brush;
        brush.CreateSolidBrush(brushColor);
        CBrush oldBrush = dc.SelectBrush(brush);

        // Pen used to draw surroundung line
        CPen blackPen;
        blackPen.CreatePen(PS_SOLID, 1, RGB(0,0,0));    
        CPen oldPen = dc.SelectPen(blackPen);

        dc.Ellipse(_point.x - _radius, _point.y - _radius, 
                   _point.x + _radius, _point.y + _radius);
        
        // restore dc
        dc.SelectPen(oldPen);
        dc.SelectBrush(oldBrush);
    }
}

/////////////////////////////////////////////////////////////////////////////
