#ifndef NOTENLISTE_H
#define NOTENLISTE_H

#include <string>
#include "Note.h"
#include "ZeichenFlaeche.h"
#include "Linie.h"

const unsigned long MaxNoten = 50;
const unsigned long Fensterbreite = 1000;
const unsigned long Fensterhoehe = 600;

class Notenliste
{
    public:
        // Konstruktor
        Notenliste(const std::string& Fach);

        bool hinzufuegen(const Note& note);

        // Diese Funktion berechnet den
        // Durchschnitt aller Noten
        Note berechneDurchschnitt() const;

        void ausgeben() const;

    private:
        void linieHinzufuegen();

    private:
        Note        m_Noten[MaxNoten];
        int         m_AnzahlNoten;
        std::string m_Fach;

        ZeichenFlaeche m_zeichenFlaeche;
        Linie       m_linien[MaxNoten];
};

#endif
