
#include "notenliste.h"
#include <iostream>
#include "Text.h"

using namespace std;

///////////////////////////////////////////////////////////

Notenliste::Notenliste(const std::string& Fach)
           :m_Fach(Fach), m_AnzahlNoten(0),
            m_zeichenFlaeche(1000,600)
{
    Text text(100, 40);
    text.setzeFarbe(RGB(200,0,0));
    text.setzeText(m_Fach);
    m_zeichenFlaeche.textHinzufuegen(text);
}

///////////////////////////////////////////////////////////

bool Notenliste::hinzufuegen(const Note& note)
{
    bool hinzufuegenOk = false;

    if(m_AnzahlNoten < MaxNoten)
    {
        m_Noten[m_AnzahlNoten] = note;
        m_AnzahlNoten++;
        hinzufuegenOk = true;

        linieHinzufuegen();
    }

    return hinzufuegenOk;
}

///////////////////////////////////////////////////////////

Note Notenliste::berechneDurchschnitt() const
{
    double summe = 0.0;

    for(long i = 0; i < m_AnzahlNoten; ++i)
    {
        const Note& aktuelleNote = m_Noten[i];
        double notenWert = aktuelleNote.holeNote();
        summe = summe + notenWert;
    }

    double durchschnitt = 0.0;

    if(m_AnzahlNoten > 0)
    {
        durchschnitt = summe / (double)m_AnzahlNoten;
    }

    Note ergebnis(durchschnitt);    // bauen wir noch ein
                                    // Notenobjekt
    
    return ergebnis;
}

///////////////////////////////////////////////////////////

void Notenliste::ausgeben() const
{
    cout << endl;
    cout << "Noten des Faches " << m_Fach << endl << endl;
    for(int i = 0; i < m_AnzahlNoten; ++i)
    {
        m_Noten[i].ausgeben();
    }

    Note durchschnittNote = berechneDurchschnitt();
    cout << "Durchschnitt : " << endl;
    durchschnittNote.gerundetAusgeben(Note::Halbe);
}

///////////////////////////////////////////////////////////

void Notenliste::linieHinzufuegen()
{
    // Die Funktion linieHinzufuegen
    // darf nur aufgerufen werden, wenn
    // es mindestens eine Note gibt !
    assert(m_AnzahlNoten > 0);

    if(m_AnzahlNoten < 2)
    {
        return;
    }

    int breite = Fensterbreite / (m_AnzahlNoten-1);
    int hoeheProNote = Fensterhoehe / 6;

    // zuerst die existierenden Linien
    // richtig setzen
    for(int i = 0; i < m_AnzahlNoten-2; ++i)
    {
        int x1 = i * breite;
        int x2 = (i+1) * breite;
        Note& note1 = m_Noten[i];
        double wert1 = note1.holeGerundeteNote(Note::Zehntel);
        Note& note2 = m_Noten[i+1];
        double wert2 = note2.holeGerundeteNote(Note::Zehntel);
        int y1 = Fensterhoehe - (int)(hoeheProNote * wert1);
        int y2 = Fensterhoehe - (int)(hoeheProNote * wert2);
        m_linien[i].setzeLinie(x1, y1, x2, y2);
    }
    // jetzt die neue Linie definieren
    Linie& linie = m_linien[m_AnzahlNoten-2];
    int x1 = Fensterbreite - breite;
    int x2 = Fensterbreite;
    Note& note1 = m_Noten[m_AnzahlNoten-2];
    double wert1 = note1.holeGerundeteNote(Note::Zehntel);
    int y1 = Fensterhoehe - (int)(hoeheProNote * wert1);
    Note& note2 = m_Noten[m_AnzahlNoten-1];
    double wert2 = note2.holeGerundeteNote(Note::Zehntel);
    int y2 = Fensterhoehe - (int)(hoeheProNote * wert2);
    linie.setzeLinie(x1, y1, x2, y2);
    linie.setzeFarbe(RGB(200,200,200));
    m_zeichenFlaeche.linieHinzufuegen(linie);
}

///////////////////////////////////////////////////////////


