#include "cdliste.h"
#include <iostream>

using namespace std;

CDListe::CDListe()
         :m_Anzahl(0)
{
}

CDListe::~CDListe()
{
}


bool CDListe::hinzufuegen(const CD& cd)
{
    bool resultat = false;

    if(m_Anzahl < MaxCDs)
    {
        m_CDs[m_Anzahl] = cd;
        m_Anzahl++;
        resultat = true;
    }

    return resultat;
}

CD& CDListe::suchen(const string& suchBegriff)
{
    static CD leereCD;  // diese wird nur einmal
                        // erzeugt !
    leereCD.setzeInterpret("LEER");

    for(long index = 0; index < m_Anzahl; ++index)
    {
        if(m_CDs[index].passt(suchBegriff))
        {
            // falls eine CD "passt"
            // springen wir aus der Funktion
            // und geben diese CD als 
            // "return"-Wert
            return m_CDs[index];
        }
    }

    // Falls wir bis hierher kommen wurde keine
    // passende CD gefunden. Wir geben stattdessen
    // diese statische "leere" CD zurck
    return leereCD;
}

void CDListe::ausgeben()
{
    for(long index = 0; index < m_Anzahl; ++index)
    {
        m_CDs[index].ausgeben();
        cout << "********************************" << endl;
    }
}

void SwapCDs(CD& a, CD& b)
{
    CD temp = a;
    a = b;
    b = temp;
}

void CDListe::sortieren(CD::Kriterium kriterium)
{
    for(long i = 0; i < m_Anzahl; ++i)
    {
        // diese Schleife geht nur bis Anzahl-1
        // denn wir greifen immer auf zwei
        // Elemente zu (mit index+1)
        for(long index = 0; index < m_Anzahl-1; index++)
        {
            CD& linke = m_CDs[index];
            CD& rechte = m_CDs[index+1];
            if(rechte.kleinerAls(linke, kriterium))
            {
                SwapCDs(linke, rechte);
            }
        }
    }
}

