// Noten.cpp: implementation of the CNoten class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Notenverwaltung.h"
#include "Noten.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_SERIAL(CNoten, CObject, 1)

CNoten::CNoten()
{

}

CNoten::~CNoten()
{

}

void CNoten::Serialize(CArchive& ar)
{
    _notenArray.Serialize(ar);
}

CNote CNoten::getAverage() const
{
    int count = _notenArray.GetSize();

    double summe = 0;
    for(int i = 0; i < count; ++i)
    {
        CNote* note = _notenArray[i];
        summe = summe + note->getMark();
    }

    double average = 0.0;
    if(0 != count)
    {
        average = summe / count;
    }

    return CNote(average);
}