// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "NotenVerwaltungTest1.h"

#include "MainFrm.h"
#include "BarView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_UPDATE_COMMAND_UI(IDM_LISTVIEW, OnUpdateListview)
	ON_COMMAND(IDM_BARVIEW, OnBarview)
	ON_UPDATE_COMMAND_UI(IDM_BARVIEW, OnUpdateBarview)
	ON_COMMAND(IDM_LISTVIEW, OnListview)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
                    :m_viewType(Listview),
                     m_listView(0),
                     m_barView(0)
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


void CMainFrame::OnUpdateListview(CCmdUI* pCmdUI) 
{
    if(Listview == m_viewType)
    {
        pCmdUI->SetCheck(1);
    }
    else
    {
        pCmdUI->SetCheck(0);
    }
}

void CMainFrame::OnBarview() 
{
    if(Barview != m_viewType)
    {
        if(0 == m_barView)
        {
            m_barView = new CBarView;
            m_barView->Create(NULL,
                                           NULL,
                                           AFX_WS_DEFAULT_VIEW,
                                           rectDefault,
                                           this,
                                           AFX_IDW_PANE_FIRST,
                                           NULL);
            CDocument* doc = GetActiveDocument();
            doc->AddView(m_barView);
            m_barView->OnInitialUpdate();
        }
        // der Zeiger sollte in ActivateFrame
        // gesetzt worden sein
        ASSERT(0 != m_listView);

        m_barView->SetDlgCtrlID(AFX_IDW_PANE_FIRST);
        m_listView->SetDlgCtrlID(AFX_IDW_PANE_FIRST+1);

        m_listView->ShowWindow(SW_HIDE);
        m_barView->ShowWindow(SW_SHOW);

        SetActiveView(m_barView);
        RecalcLayout();
    }
    m_viewType = Barview;	
}

void CMainFrame::OnUpdateBarview(CCmdUI* pCmdUI) 
{
    if(Barview == m_viewType)
    {
        pCmdUI->SetCheck(1);
    }
    else
    {
        pCmdUI->SetCheck(0);
    }
}

void CMainFrame::OnListview() 
{
    if(Listview != m_viewType)
    {
        // der Zeiger sollte in ActivateFrame
        // gesetzt worden sein
        ASSERT(0 != m_listView);

        m_barView->SetDlgCtrlID(AFX_IDW_PANE_FIRST+1);
        m_listView->SetDlgCtrlID(AFX_IDW_PANE_FIRST);

        m_barView->ShowWindow(SW_HIDE);
        m_listView->ShowWindow(SW_SHOW);

        SetActiveView(m_listView);
        RecalcLayout();
    }

    m_viewType = Listview;	
}

void CMainFrame::ActivateFrame(int nCmdShow) 
{
    if(0 == m_listView)
    {
        m_listView = GetActiveView();
    }
	CFrameWnd::ActivateFrame(nCmdShow);
}
