// BarView.cpp : implementation file
//

#include "stdafx.h"
#include "NotenVerwaltungTest1.h"
#include "BarView.h"
#include "NotenVerwaltungTest1Doc.h"
#include "Note.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBarView

IMPLEMENT_DYNCREATE(CBarView, CScrollView)

CBarView::CBarView()
{
}

CBarView::~CBarView()
{
}


BEGIN_MESSAGE_MAP(CBarView, CScrollView)
	//{{AFX_MSG_MAP(CBarView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBarView drawing

void CBarView::OnDraw(CDC* pDC)
{
    CNotenVerwaltungTest1Doc* doc = GetDocument();
	CRect rect;
    GetClientRect(rect);

    const int height = rect.Height() - 20;

    CBrush redBrush;
    redBrush.CreateSolidBrush(RGB(200,40,40));
    CBrush greenBrush;
    greenBrush.CreateSolidBrush(RGB(0, 200, 30));
    CBrush* oldBrush = pDC->SelectObject(&greenBrush);
    CPen pen;
    pen.CreatePen(PS_SOLID, 2, RGB(0,0,0));
    CPen* oldPen = pDC->SelectObject(&pen);

    const NotenArray& array = doc->getNotenArray();
    int arraySize = array.GetSize();
    for(int i = 0; i < arraySize; ++i)
    {
        CNote* note = array[i];
        double notenWert = note->getMark();

        if(notenWert < 4.0)
        {
            pDC->SelectObject(redBrush);
        }
        else
        {
            pDC->SelectObject(greenBrush);
        }

        int markHeight = notenWert * height / 6.0;
        CRect notenRect(10+i*40,
                                   rect.Height() - 10 - markHeight,
                                   30+i*40,
                                   rect.Height() - 10);
        pDC->Rectangle(notenRect);
 //       pDC->FillSolidRect(notenRect, RGB(200, 40, 40));
    }

    pDC->SelectObject(oldBrush);
    pDC->SelectObject(oldPen);
}

/////////////////////////////////////////////////////////////////////////////
// CBarView diagnostics

#ifdef _DEBUG
void CBarView::AssertValid() const
{
	CView::AssertValid();
}

void CBarView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBarView message handlers

void CBarView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
    setScrollBars();	
}

void CBarView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
    setScrollBars();

    Invalidate();
}

void CBarView::setScrollBars()
{
    CNotenVerwaltungTest1Doc* doc = GetDocument();
	CRect rect;
    GetClientRect(rect);
	
    const NotenArray& array = doc->getNotenArray();

    int arraySize = array.GetSize();
    int docSize = arraySize * 20; // wir brauchen 20 Pixel pro Note
    CSize size(docSize, 600);
    SetScrollSizes(MM_TEXT, size);
//    SetScaleToFitSize(size);
}

CNotenVerwaltungTest1Doc* CBarView::GetDocument()
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CNotenVerwaltungTest1Doc)));
	return (CNotenVerwaltungTest1Doc*)m_pDocument;
}
