#ifndef NOTENLISTE_H
#define NOTENLISTE_H

#include <string>
#include "Note.h"
#include "ZeichenFlaeche.h"
#include "Linie.h"

const int Hoehe  = 240;
const int Breite = 300;


const unsigned long MaxNoten = 50;

class Notenliste
{
    public:
        // Konstruktor
        Notenliste(const std::string& Fach);

        bool hinzufuegen(const Note& note);

        // Diese Funktion berechnet den
        // Durchschnitt aller Noten
        Note berechneDurchschnitt() const;

        void ausgeben() const;

        void ausgeben(ostream& out) const;

    private:
        void neueLinie();
        int berechneY(const Note& note);

    private:
        Note        m_Noten[MaxNoten];
        int         m_AnzahlNoten;
        std::string m_Fach;
        ZeichenFlaeche m_flaeche;

        Linie   m_linien[MaxNoten-1];
};

#endif
