#ifndef KREISTEXT_H // der sogenannte Include-Blocker
#define KREISTEXT_H

#include "Kreis.h"
#include "Text.h"
#include "ZeichenFlaeche.h"
#include <string>


struct Koordinaten
{
	long x;
	long y;
};


class KreisText
{
	public:
        // Kopierkonstruktor
        KreisText(const KreisText& c);

        // Zwei Konstruktoren mit Parametern
		// Der erste nimmt zwei longs als Koordinaten
		KreisText(long x, long y, long kreisRadius,
                  ZeichenFlaeche& zeichenFlaeche);
		// Dieser zweite Konstruktor nimmt als Parameter
		// eine Koordinaten-Struktur
		KreisText(Koordinaten koordinaten, long kreisRadius,
                  ZeichenFlaeche& zeichenFlaeche);

		// Hier die Funktionen zum setzen der Koordinaten.
		// Setze die Koordinaten mit zwei long's als
        // Parameter
		void setzeKoordinaten(long x, long y);
		// Setze die Koordinaten mit einer Koordinate-Struktur
        // als Parameter
		void setzeKoordinaten(Koordinaten koordinaten);

		void setzeKreisFarbe(unsigned char rot,
							 unsigned char gruen,
							 unsigned char blau);

		void setzeKreisRadius(long radius);

		void setzeText(const std::string& text);

        // statische Methode zur Abfrage der Anzahl
        // Objekte
        static unsigned long holeAnzahlObjekte()
        {
            return s_AnzahlObjekte;
        }

        // Datenelemente
	private:
        struct Farbe
        {
            unsigned char Rot;
            unsigned char Gruen;
            unsigned char Blau;
        };

		Kreis		    m_Kreis;
		Text		    m_Text;
		Koordinaten     m_Koordinaten;
		Farbe   	    m_Farbe;
        string          m_Bezeichnung;
        long            m_KreisRadius;
        ZeichenFlaeche& m_ZeichenFlaeche;

        static unsigned long s_AnzahlObjekte;
};


#endif