#include "KreisText.h"

////////////////////////////////////////////////////////////////

const COLORREF Schwarz = RGB(0,0,0);
const COLORREF Weiss = RGB(255,255,255);
const string InitText("Hallo");

////////////////////////////////////////////////////////////////

unsigned long KreisText::s_AnzahlObjekte = 0;

////////////////////////////////////////////////////////////////

// Der Konstruktor muss eine Initialisierungsliste
// verwenden, denn die Elemente haben auch Konstruktoren
// mit Parametern
KreisText::KreisText(long x, long y, long kreisRadius,
                     ZeichenFlaeche& zeichenFlaeche)
          :m_Text(x,y), m_Kreis(x, y, kreisRadius),
           m_ZeichenFlaeche(zeichenFlaeche)
{
    m_Koordinaten.x = x;
    m_Koordinaten.y = y;
    m_KreisRadius = kreisRadius;
    // Dei Konstante Weiss ist oben definiert!
    m_Text.setzeFarbe(Weiss);
    // Die Konstante InitText wurde oben definiert!
    m_Bezeichnung = InitText;
    m_Text.setzeText(m_Bezeichnung);
    // Mit diesem Konstruktor knnen wir die Elemente
    // direkt darstellen
    zeichenFlaeche.kreisHinzufuegen(m_Kreis);
    zeichenFlaeche.textHinzufuegen(m_Text);

    s_AnzahlObjekte++;
}

////////////////////////////////////////////////////////////////

KreisText::KreisText(Koordinaten koordinaten, long kreisRadius,
                     ZeichenFlaeche& zeichenFlaeche)
          :m_Text(koordinaten.x, koordinaten.y), 
		   m_Kreis(koordinaten.x, koordinaten.y, kreisRadius),
           m_ZeichenFlaeche(zeichenFlaeche)
{
    m_Koordinaten = koordinaten;
    m_KreisRadius = kreisRadius;
    // Dei Konstante Weiss ist oben definiert!
    m_Text.setzeFarbe(Weiss);
    // Die Konstante InitText wurde oben definiert !
    m_Bezeichnung = InitText;
    m_Text.setzeText(InitText);
    // Mit diesem Konstruktor knnen wir die Elemente
    // direkt darstellen
    zeichenFlaeche.kreisHinzufuegen(m_Kreis);
    zeichenFlaeche.textHinzufuegen(m_Text);

    s_AnzahlObjekte++;
}

////////////////////////////////////////////////////////////////
// Kopierkonstruktor
KreisText::KreisText(const KreisText& c)
          :m_ZeichenFlaeche(c.m_ZeichenFlaeche),
           m_Text(c.m_Koordinaten.x, c.m_Koordinaten.y),
           m_Kreis(c.m_Koordinaten.x, c.m_Koordinaten.y, c.m_KreisRadius)
{
    m_Text.setzeText(c.m_Bezeichnung);
    setzeKreisFarbe(c.m_Farbe.Rot, c.m_Farbe.Gruen, c.m_Farbe.Blau);

    m_ZeichenFlaeche.kreisHinzufuegen(m_Kreis);
    m_ZeichenFlaeche.textHinzufuegen(m_Text);

    s_AnzahlObjekte++;
}                       

////////////////////////////////////////////////////////////////

void KreisText::setzeKoordinaten(long x, long y)
{
    m_Koordinaten.x = x;
    m_Koordinaten.y = y;
	m_Kreis.setzeKoordinaten(x, y);
	m_Text.setzeKoordinaten(x, y);
}

////////////////////////////////////////////////////////////////

void KreisText::setzeKoordinaten(Koordinaten koordinaten)
{
    m_Koordinaten = koordinaten;
	m_Kreis.setzeKoordinaten(koordinaten.x, koordinaten.y);
	m_Text.setzeKoordinaten(koordinaten.x, koordinaten.y);
}

////////////////////////////////////////////////////////////////

void KreisText::setzeKreisFarbe(unsigned char rot,
							    unsigned char gruen,
							    unsigned char blau)
{
	// Hier mssen wir entscheiden ob wir
	// den Text schwarz oder weiss machen
	COLORREF textFarbe = Weiss;

	if(blau+rot+gruen > 400)
	{
		textFarbe = Schwarz;
	}

	if(gruen > blau+rot+150)
	{
		textFarbe = Schwarz;
	}
    m_Farbe.Rot = rot;
    m_Farbe.Gruen = gruen;
    m_Farbe.Blau = blau;

	m_Kreis.setzeFarbe(RGB(rot, gruen, blau));
	m_Text.setzeFarbe(textFarbe);
}

////////////////////////////////////////////////////////////////

void KreisText::setzeKreisRadius(long radius)
{
    m_KreisRadius = radius;
	m_Kreis.setzeRadius(m_KreisRadius);
}

////////////////////////////////////////////////////////////////

void KreisText::setzeText(const string& text)
{
    m_Bezeichnung = text;
	m_Text.setzeText(m_Bezeichnung);
}

////////////////////////////////////////////////////////////////


