

#ifndef HTMLDOCUMENT_H
#define HTMLDOCUMENT_H

////////////////////////////////////////////////////////

#include <string>
#include <sstream>

////////////////////////////////////////////////////////

class HtmlDocument
{
public:
    HtmlDocument(const std::string& fileName,
                 const std::string& title);

    void save();
    void saveAs(const std::string& filename);

    template<class T>
    std::stringstream& operator << (const T& data)
    {
        _body << data;
        _saved = false;
        return _body;
    }

    void print();
    void show();

private:
    std::string       _fileName;
    std::string       _title;
    std::stringstream _body;
    bool              _saved;
};

////////////////////////////////////////////////////////

class HtmlTag
{
public:
    // Konstruktor
    HtmlTag(const std::string& tag) : _tag(tag)
    {
    }

    template<class T>
    std::stringstream& operator << (const T& data)
    {
        _data << data;
        return _data;
    }

    void clear();

    // diese globale Funktion darf
    // auf unsere privaten Elemente
    // zugreifen
    friend HtmlDocument& operator << (HtmlDocument& doc,
                                      const HtmlTag& tag);

    friend HtmlTag& operator << (HtmlTag& lhs,
                                 const HtmlTag& rhs);

private:
    std::string       _tag;
    std::stringstream _data;
};

////////////////////////////////////////////////////////


HtmlDocument& operator<<(HtmlDocument& doc,
                         const HtmlTag& tag);


////////////////////////////////////////////////////////

// mit dieser Methode lassen sich
// verschachtelte tags erzeugen
HtmlTag& operator<<(HtmlTag& lhs, const HtmlTag& rhs);

////////////////////////////////////////////////////////

#endif