

// Fr die Console-Klasse
#include "Console.h"
// Fr Ein- und Ausgabe
#include <iostream> 
// Fr string
#include <string>
// Fr getch
#include <conio.h>

using namespace std;

///////////////////////////////////////////////////////////////////////////////
// Funktionsprototypen

double BerechneDurchschnitt(double Summe, unsigned int Anzahl);
bool Weitermachen();
double NoteEinlesen();
void Begruessung();
void DurchschnittAusgeben(double Durchschnitt);


///////////////////////////////////////////////////////////////////////////////
// Globale Variable fr
// das Lschen des Bildschirms
// oder setzen des Cursors

Console dieConsole;

///////////////////////////////////////////////////////////////////////////////

int main()
{
    double NotenSumme = 0.0;
    unsigned int AnzahlNoten = 0;

    Begruessung();

    while(Weitermachen())
    {
        NotenSumme = NotenSumme + NoteEinlesen();
        AnzahlNoten++;
        double Durchschnitt = BerechneDurchschnitt(NotenSumme, AnzahlNoten);
        
        DurchschnittAusgeben(Durchschnitt);
    }

    return 0;
};

///////////////////////////////////////////////////////////////////////////////

double BerechneDurchschnitt(double Summe, unsigned int Anzahl)
{
    double Ergebnis = 0.0;

    if(Anzahl != 0)
    {
        // Anzahl wird explizit in einen double umgewandelt
        Ergebnis = Summe / (double)Anzahl;
    }
    
    return Ergebnis;
}

///////////////////////////////////////////////////////////////////////////////

bool Weitermachen()
{
    dieConsole.Clear();
    dieConsole.Locate(0,3);

    cout << endl << "Wollen sie eine Note eingeben ? [j/n] ";

    char eingabe;
    cin >> eingabe;

    if('j' == eingabe)
    {
        return true;
    }
    else
    {
        return false;
    }
}

///////////////////////////////////////////////////////////////////////////////

double NoteEinlesen()
{
    dieConsole.Clear();
    dieConsole.Locate(0,3);

    cout << endl << "Bitte Note zwischen 1.0 und 6.0 eingeben : ";

    double Eingabe = 0.0;

    while(Eingabe > 6.0 || Eingabe < 1.0)
    {
        cin >> Eingabe;
    }

    return Eingabe;
}

///////////////////////////////////////////////////////////////////////////////

void Begruessung()
{
    dieConsole.Clear();

    cout << endl << "Hallo, ich bin das Notenprogramm !" << endl << endl;
    cout << "Weiter mit Tastendruck";
    
    // Tastendruck abwarten
    getch();
}

///////////////////////////////////////////////////////////////////////////////

void DurchschnittAusgeben(double Durchschnitt)
{
    cout << endl << "Dein Durchschnitt ist : " << Durchschnitt << endl << endl;

    cout << "Weiter mit Tastendruck";

    // Tastendruck abwarten
    getch();
}