// BarView.cpp : implementation file
//

#include "stdafx.h"
#include "NotenVerwaltungTest1.h"
#include "BarView.h"
#include "NotenVerwaltungTest1Doc.h"
#include "Note.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBarView
const int Height = 400;
const int TopMargin = 10;
const int BarWidth = 40;
const int BarMargin = 10;
const UINT TimerId = 1;

IMPLEMENT_DYNCREATE(CBarView, CScrollView)

CBarView::CBarView()
:_scaledView(false),
 _blink(false)
{
}

CBarView::~CBarView()
{
}


BEGIN_MESSAGE_MAP(CBarView, CScrollView)
	//{{AFX_MSG_MAP(CBarView)
	ON_COMMAND(ID_BALKENANSICHT_SKALIERT, OnBalkenansichtSkaliert)
	ON_UPDATE_COMMAND_UI(ID_BALKENANSICHT_SKALIERT, OnUpdateBalkenansichtSkaliert)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_WM_ERASEBKGND()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBarView drawing

void CBarView::OnDraw(CDC* pDC)
{
    drawBackGround(pDC);

    CNotenVerwaltungTest1Doc* doc = GetDocument();

    CBrush redBrush;
    redBrush.CreateSolidBrush(RGB(200,40,40));
    CBrush greenBrush;
    greenBrush.CreateSolidBrush(RGB(0, 200, 30));
    CBrush* oldBrush = pDC->SelectObject(&greenBrush);
    CPen pen;
    pen.CreatePen(PS_SOLID, 2, RGB(0,0,0));
    CPen* oldPen = pDC->SelectObject(&pen);

    const NotenArray& array = doc->getNotenArray();
    int arraySize = array.GetSize();
    for(int i = 0; i < arraySize; ++i)
    {
        CNote* note = array[i];
        double notenWert = note->getMark();

        if(notenWert < 4.0)
        {
            pDC->SelectObject(&redBrush);
        }
        else
        {
            pDC->SelectObject(&greenBrush);
        }

        if(6.0 == notenWert && _blink)
        {
            continue;
        }
        int markHeight = (int)((notenWert-1) * Height / 5.0);
        markHeight = max(markHeight, 10);
        CRect notenRect(BarMargin + (BarMargin + BarWidth) * i,
                                   TopMargin + Height - markHeight,
                                   (BarMargin + BarWidth) * (i+1),
                                   TopMargin + Height);
        pDC->Rectangle(notenRect);

        CString notenString = note->asString();
        pDC->SetBkMode(TRANSPARENT);
        pDC->SetTextColor(RGB(255,255,255));
        pDC->TextOut(5 + BarMargin + (BarMargin + BarWidth) * i,
                                 TopMargin + Height - markHeight + 10,
                                 notenString);

    }

    pDC->SelectObject(oldBrush);
    pDC->SelectObject(oldPen);
}

/////////////////////////////////////////////////////////////////////////////
// CBarView diagnostics

#ifdef _DEBUG
void CBarView::AssertValid() const
{
	CView::AssertValid();
}

void CBarView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBarView message handlers

void CBarView::OnInitialUpdate() 
{
    SetTimer(TimerId, 1000, 0);
	CScrollView::OnInitialUpdate();
    setScrollBars();	
}

void CBarView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
    setScrollBars();
    Invalidate();
}

void CBarView::setScrollBars()
{
    int docSize = getDocWidth();
    CSize size(docSize, 2*TopMargin + Height);
    if(_scaledView)
    {
        SetScaleToFitSize(size);
    }
    else
    {
        SetScrollSizes(MM_TEXT, size);
    }
}

CNotenVerwaltungTest1Doc* CBarView::GetDocument()
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CNotenVerwaltungTest1Doc)));
	return (CNotenVerwaltungTest1Doc*)m_pDocument;
}

void CBarView::OnBalkenansichtSkaliert() 
{
    _scaledView = !_scaledView;
    setScrollBars();
    Invalidate();
}

void CBarView::OnUpdateBalkenansichtSkaliert(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck(_scaledView ? 1 : 0);	
}

void CBarView::OnFilePrint() 
{
    CScrollView::OnFilePrint();
}

void CBarView::OnFilePrintPreview() 
{
    CScrollView::OnFilePrintPreview();
}

void CBarView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
    if(pDC->IsPrinting())
    {
        pDC->SetMapMode(MM_LOMETRIC);
    }

	CScrollView::OnPrepareDC(pDC, pInfo);
}

BOOL CBarView::OnPreparePrinting(CPrintInfo* pInfo) 
{
	DoPreparePrinting(pInfo);
	
	return CScrollView::OnPreparePrinting(pInfo);
}

void CBarView::drawBackGround(CDC *pDC)
{
    int docWidth = getDocWidth();
    int docHeight = Height;
    int markHeight = docHeight / 5;
    
    CPen pen;
    pen.CreatePen(PS_SOLID, 2, RGB(0,0,0));

    CPen* oldPen = pDC->SelectObject(&pen);
    for(int i = 0; i < 6; ++i)
    {
        pDC->MoveTo(0, TopMargin + i * markHeight);
        pDC->LineTo(docWidth + BarMargin, TopMargin + i * markHeight);
    }
/*
    pDC->FillSolidRect(BarMargin, TopMargin, 
                                    docWidth, docHeight,
                                    RGB(150,150,150));
*/
}

int CBarView::getDocWidth()
{
    CNotenVerwaltungTest1Doc* doc = GetDocument();
	
    const NotenArray& array = doc->getNotenArray();

    int arraySize = array.GetSize();
    int docWidth = (BarMargin + BarWidth) * arraySize + BarMargin;
    return docWidth;
}

BOOL CBarView::OnEraseBkgnd(CDC* pDC) 
{
    CRect rect;
	GetClientRect(rect);

    pDC->FillSolidRect(rect, RGB(180,180,180));

    return TRUE;
}

void CBarView::OnTimer(UINT nIDEvent) 
{
    if(TimerId == nIDEvent)
    {
        _blink = !_blink;

        Invalidate();
    }
	CScrollView::OnTimer(nIDEvent);
}

void CBarView::OnDestroy() 
{
	CScrollView::OnDestroy();
	
    KillTimer(TimerId);	
}
