
#include "SerialPort.h"
#include <string>
#include <sstream>

/////////////////////////////////////////////////

SerialPort::SerialPort()
           :m_handle(INVALID_HANDLE_VALUE)
{
}

/////////////////////////////////////////////////

SerialPort::SerialPort(unsigned char portNumber)
           :m_handle(INVALID_HANDLE_VALUE)
{
    open(portNumber);
}

/////////////////////////////////////////////////

SerialPort::~SerialPort()
{
    close();
}

/////////////////////////////////////////////////

void SerialPort::open(unsigned char portNumber)
{
    std::stringstream stream;
    stream << "COM";
    long temp = portNumber;
    stream << temp;
    std::string port = stream.str();

    m_handle = CreateFile(port.c_str(),
                          GENERIC_READ | GENERIC_WRITE,
                          0,
                          0,
                          OPEN_EXISTING,
                          FILE_ATTRIBUTE_NORMAL,
                          0);
    
    if(INVALID_HANDLE_VALUE == m_handle)
    {        
        DWORD error = GetLastError();
        std::stringstream stream;
        stream << "CreateFile misslungen mit error code : " << error;
        throw stream.str();
    }
}

/////////////////////////////////////////////////

void SerialPort::close()
{
    if(INVALID_HANDLE_VALUE != m_handle)
    {
        CloseHandle(m_handle);
        m_handle = INVALID_HANDLE_VALUE;
    }
}

/////////////////////////////////////////////////

unsigned char SerialPort::readByte()
{
    if(INVALID_HANDLE_VALUE == m_handle)
    {
        throw std::string("readByte : Port nicht offen");
    }

    unsigned char data = 0;

    DWORD bytesRead = 0;
    BOOL result = FALSE;
    result = ReadFile(m_handle,      // file handle
                      (LPVOID)&data, // Zeiger auf Speicher
                      1,             // Lnge des Speichers
                      &bytesRead,    // Zeiger auf DWORD
                      0);            // Jetzt noch keine OVERLAPPED
    
    if(FALSE == result)
    {
        DWORD error = GetLastError();
        std::stringstream stream;
        stream << "ReadFile misslungen mit error code : " << error;
        throw stream.str();
    }

    return 0;
}

/////////////////////////////////////////////////

void SerialPort::writeByte(unsigned char data)
{
    if(INVALID_HANDLE_VALUE == m_handle)
    {
        throw std::string("writeByte : Port nicht offen");
    }
    
    DWORD bytesWritten = 0;
    BOOL result = FALSE;
    result = WriteFile(m_handle,
                       &data,
                       1,
                       &bytesWritten,
                       0);
    if(FALSE == result)
    {
        DWORD error = GetLastError();
        std::stringstream stream;
        stream << "WriteFile misslungen mit error code : " << error;
        throw stream.str();
    }
}

/////////////////////////////////////////////////
