#include <iostream>
#include "Console.h"
using namespace std;


/*****************************************
Globale Konstanten
******************************************/

const int spalteneinzug = 5;			// Spalteneinzug von links 
const int fragezeile	= 4;			// Die Eingabezeile

const int fensterbreite = 80;			// Fensterbreite(Zeichen)

/*****************************************
Prototyp
******************************************/

void begruessung();
float durchschnitt(double summe, int anzahl);
bool weitermachen(int zeile, int spalte);
float noteeinlesen(int zeile,int spalte);
void berechnen();
void line(char zeichen, int anzahl = fensterbreite);

Console Konsole;


/*****************************************
Main-Funktion
******************************************/

int main()
{
    begruessung();
    berechnen();
    return 0;
}

/*****************************************
Die Funktion "berechnen" berechnet den 
durchsschnitt und gibt ihn auf dem 
display aus.
******************************************/
void berechnen()
{
    double summe = 0;
    int anzahl = 0;
    do
    {
        
        summe += noteeinlesen(fragezeile,spalteneinzug);
        anzahl++;
        Konsole.Locate((fragezeile + 2 + anzahl),spalteneinzug);
        cout << "Anzahl Noten : " << anzahl << "    ";
        cout << "Notenduchschnitt : " << durchschnitt(summe,anzahl);
    }
    while (weitermachen(fragezeile,spalteneinzug));
}


void begruessung()
{
    Konsole.Clear();
    line('*');
    line(' ',spalteneinzug);
    cout  << "Willkommen zum Notendurchschnitt-Kalkulationsprogramm" << endl;
    line('*');
}

/*****************************************
Die Funktion "line" gibt anzahl zeichen
auf dem display aus.
******************************************/

void line(char zeichen, int anzahl)
{
    for ( char i = 0;(i < anzahl);i++)
    {
        cout << zeichen;
    }
}

/*****************************************
Die Funktion "durchschnitt" berechnet den
durchschnitt aus den argumenten.

  Der Rckgabewert enthlt den durschschnitt.
******************************************/


float durchschnitt(double summe, int anzahl)
{
    return ( summe / anzahl);
}

/*****************************************
Die Funktion "weitermachen" erwartet eine 
eingabe auf dem display um weiterzumachen.

  Mit den Argumenten "zeile" und "spalte" 
  wird der Anfangspunkt des Textes definiert.
  
    Der Rckgabewert enthlt True wenn ein 
    Y oder y eingegeben wurde.
******************************************/


bool weitermachen(int zeile, int spalte)
{
    char eingabe;
    Konsole.Locate (zeile,0);
    line(' ');
    Konsole.Locate(zeile,spalte);
    cout << "Wollen Sie eine weitere Note eingeben ? [Y/N]";
    cin >> eingabe;
    
    return (eingabe == 'Y' || eingabe == 'y');
}

/*****************************************
Die Funktion "noteeinlesen" liest eine
Note ein und kontrolliert sie auf ihre 
gltikeit.

Mit den Argumenten "zeile" und "spalte" 
wird der Anfangspunkt des Textes definiert.
  
Der Rckgabewert enthlt die eingegebene
Note.
******************************************/

float noteeinlesen(int zeile,int spalte)
{
    
    const int tiefstenote	= 1;
    const int hoechstenote	= 6;
    
    float Note = 0;
    
    do
    {
        Konsole.Locate (zeile,0);
        line(' ');
        Konsole.Locate(zeile,spalte);
        cout << "Bitte Note eingeben (1...6) : ";
        cin >> Note;
        
        
        Konsole.Locate (zeile + 1,0);
        line(' ');
        if (!(Note >= tiefstenote) || !(Note <= hoechstenote))
        {
            Note = 0;
            Konsole.Locate (zeile + 1,spalte);
            cout << " Falsche Note !!! ";			
        }
    }while (Note == 0);
    
    return Note;
}

