#ifndef ZAHL_H
#define ZAHL_H

#include <string>

enum Basis
{
    Binaer = 2,
    Octal = 8,
    Decimal = 10,
    Hexa = 16
};

class Zahl
{
public:
    Zahl(const std::string& text, Basis basis);
    Zahl(double d);
    Zahl(long l);

    double toDouble() const;
    long toLong() const;
    std::string toString(Basis basis) const;

    operator double() const
    {
        return toDouble();
    }

    Zahl& operator=(double d);
    Zahl& operator=(long l);
    Zahl& operator=(const Zahl& z);

private:
    Basis _basis;
    std::string _string;
};


#endif