#include "Zahl.h"
#include <iomanip>
#include <sstream>

Zahl::Zahl(const std::string& text, Basis basis)
:_basis(basis), _string(text)
{
}

Zahl::Zahl(double d)
:_basis(Decimal)
{
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit);
    stream << std::setprecision(16);
    stream << d;
    stream >> _string;
}

Zahl::Zahl(long l)
:_basis(Decimal)
{
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit);
    stream << l;
    stream >> _string;
}

Zahl& Zahl::operator =(long l)
{
    _basis = Decimal;
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit);
    stream << l;
    stream >> _string;

    return *this;
}

Zahl& Zahl::operator =(double d)
{
    _basis = Decimal;
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit);
    stream << d;
    stream >> _string;

    return *this;
}

long Zahl::toLong() const
{
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit);
    stream << std::setbase(_basis);
    stream << _string;
    long result = 0;
    stream >> result;
    return result;    
}



