
#include "HtmlDocument.h"

int main()
{
    int test[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 };

    const long length = sizeof(test) / sizeof(test[0]);

    HtmlDocument doc("Test.html", "Das ist ein Test");
    HtmlTag heading1("H9");

    heading1 << "Titel";
    doc << heading1;

    for(int i = 0; i < length; ++i)
    {
        // so gibt es eine Liste
        HtmlTag listentry("LI");
        listentry << test[i];
        doc << listentry;
    }

    for(int i = 0; i < length; ++i)
    {
        // so gibt es alle untereinander aus
        HtmlTag linebreak("br");
        doc << linebreak;
        doc << test[i];
    }

    // am besten eine Tabelle
    HtmlTag table("table");
    HtmlTag titleRow("tr");
    HtmlTag titleCell("td");
    HtmlAttribute tableAttribute("border = \"2\"");
    titleCell << "Ueberschrift";
    titleRow << titleCell;
    table << tableAttribute;
    table << titleRow;
    for(int i = 0; i < length; ++i)
    {
        HtmlTag row("tr");
        HtmlTag cell("td");
        cell << test[i];
        row << cell;
        table << row;
    }
    doc << table;
        
    doc.save();
    doc.show();

    return 0;
}

