#include "HtmlDocument.h"
#include <fstream>
#include <windows.h>

////////////////////////////////////////////////////////

HtmlDocument::HtmlDocument(const std::string& fileName,
                           const std::string& title)
:_fileName(fileName),
 _title(title),
 _saved(false)
{
}

////////////////////////////////////////////////////////

void HtmlDocument::save()
{
    std::ofstream htmlstream(_fileName.c_str());

    htmlstream << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">" << std::endl;
    htmlstream << "<html>" << std::endl;
    htmlstream << "<head>" << std::endl;
    htmlstream << "<title>" << std::endl;
    htmlstream << _title << std::endl;
    htmlstream << "</title>" << std::endl;
    htmlstream << "</head>" << std::endl;
    htmlstream << "<body>" << std::endl;
    htmlstream << _body.str() << std::endl;
    htmlstream << "</body>" << std::endl;
    htmlstream << "</html>" << std::endl;

    _saved = true;
}

////////////////////////////////////////////////////////

void HtmlDocument::saveAs(const std::string& filename)
{
    _fileName = filename;
    save();
}

////////////////////////////////////////////////////////

void HtmlDocument::print()
{
    if(false == _saved)
    {
        save();
    }

    ShellExecute(0, "print", _fileName.c_str(), 0, 0, SW_HIDE);
}

////////////////////////////////////////////////////////

void HtmlDocument::show()
{
    if(false == _saved)
    {
        save();
    }

    ShellExecute(0, "open", _fileName.c_str(), 0, 0, SW_SHOW);
}

////////////////////////////////////////////////////////

HtmlDocument& operator<<(HtmlDocument& doc,
                         const HtmlTag& tag)
{
    doc << "<" << tag._tag << tag._attribute.str() << ">";
    doc << tag._data.str();
    doc << "</" << tag._tag << ">" << std::endl;

    return doc;
}

////////////////////////////////////////////////////////

HtmlTag& operator <<(HtmlTag& lhs, const HtmlTag& rhs)
{
    lhs._data << "<" << rhs._tag << rhs._attribute.str() << ">";
    lhs._data << rhs._data.str();
    lhs._data << "</" << rhs._tag << ">" << std::endl;

    return lhs;
}

////////////////////////////////////////////////////////

void HtmlTag::clear()
{
    _data.str().resize(0);
}

////////////////////////////////////////////////////////

HtmlAttribute::HtmlAttribute(const std::string& attribute)
{
    _data << " " << attribute;
}

////////////////////////////////////////////////////////

HtmlTag& operator<<(HtmlTag& lhs, const HtmlAttribute& rhs)
{
    lhs._attribute << rhs._data.str();
    return lhs;
}