
#include "notenliste.h"
#include <iostream>

using namespace std;

///////////////////////////////////////////////////////////

Notenliste::Notenliste(const std::string& Fach)
           :m_Fach(Fach), m_AnzahlNoten(0)
{
}

///////////////////////////////////////////////////////////

bool Notenliste::hinzufuegen(const Note& note)
{
    bool hinzufuegenOk = false;

    if(m_AnzahlNoten < MaxNoten)
    {
        m_Noten[m_AnzahlNoten] = note;
        m_AnzahlNoten++;
        hinzufuegenOk = true;
    }

    return hinzufuegenOk;
}

///////////////////////////////////////////////////////////

Note Notenliste::berechneDurchschnitt() const
{
    double summe = 0.0;

    for(long i = 0; i < m_AnzahlNoten; ++i)
    {
        const Note& aktuelleNote = m_Noten[i];
        double notenWert = aktuelleNote.holeNote();
        summe = summe + notenWert;
    }

    double durchschnitt = 0.0;

    if(m_AnzahlNoten > 0)
    {
        durchschnitt = summe / (double)m_AnzahlNoten;
    }

    Note ergebnis(durchschnitt);    // bauen wir noch ein
                                    // Notenobjekt
    
    return ergebnis;
}

///////////////////////////////////////////////////////////

void Notenliste::ausgeben() const
{
    cout << endl;
    cout << "Noten des Faches " << m_Fach << endl << endl;
    for(int i = 0; i < m_AnzahlNoten; ++i)
    {
        m_Noten[i].ausgeben();
    }

    Note durchschnittNote = berechneDurchschnitt();
    cout << "Durchschnitt : " << endl;
    durchschnittNote.gerundetAusgeben(Note::Halbe);
}

///////////////////////////////////////////////////////////


