///////////////////////////////////////////////////////////

#include "ZeichenFlaeche.h"
#include "Kreis.h"
#include "Text.h"

///////////////////////////////////////////////////////////


// Konstruktor
ZeichenFlaeche::ZeichenFlaeche(long breite, long hoehe)
{
	try
	{
		// mit dieser Anweisung wird der das Exe gestartet
		// und eine ZeichenFlaeche darin erzeugt
		m_zeichenFlaeche.CreateInstance("TsuZeichnen.ZeichenFlaeche");

		// jetzt setzen wir die breite und die hoehe
		m_zeichenFlaeche->Breite = breite;
		m_zeichenFlaeche->Hoehe = hoehe;
		// Das Fenster mit der ZeichenFlaeche wird jetzt
		// sichtbar
	}
	catch(_com_error&)
	{
		MessageBox(0, "Geht leider nicht", "Fehler", MB_OK);
	}
}

///////////////////////////////////////////////////////////

void ZeichenFlaeche::setzeFarbe(COLORREF farbe)
{
	try
	{
		m_zeichenFlaeche->Farbe = farbe;
	}
	catch(_com_error&)
	{
	}
}

///////////////////////////////////////////////////////////

void ZeichenFlaeche::kreisHinzufuegen(Kreis& kreis)
{
	try
	{
		TSUZEICHNENLib::IKreisPtr kreisPtr;
		kreisPtr = m_zeichenFlaeche->NeuerKreis();

		kreis.setzePointer(kreisPtr);
	}
	catch(_com_error&)
	{
	}
}

///////////////////////////////////////////////////////////

void ZeichenFlaeche::textHinzufuegen(Text& text)
{
	try
	{
		TSUZEICHNENLib::ITextPtr textPtr;
		textPtr = m_zeichenFlaeche->NeuerText();

		text.setzePointer(textPtr);
	}
	catch(_com_error&)
	{
	}
}

//////////////////////////////////////////////////////////
