
#include "Text.h"

///////////////////////////////////////////////////////////

Text::Text(long x, long y)
     :m_x(x),  // Initialisierung
	  m_y(y),  // mit Initialisierungsliste
	  m_farbe(RGB(10,10,10))
{
}

///////////////////////////////////////////////////////////

void Text::setzeFarbe(COLORREF farbe)
{
	m_farbe = farbe;

	if(m_textPtr != 0)
	{
		try
		{
			m_textPtr->Farbe = m_farbe;
		}
		catch(_com_error&)
		{
		}
	}
}

///////////////////////////////////////////////////////////

void Text::setzeKoordinaten(long x, long y)
{
	m_x = x;
	m_y = y;

	if(m_textPtr != 0)
	{
		try
		{
			m_textPtr->X = m_x;
			m_textPtr->Y = m_y;
		}
		catch(_com_error&)
		{
		}
	}
}

///////////////////////////////////////////////////////////

void Text::setzePointer(const TSUZEICHNENLib::ITextPtr& ptr)
{
	m_textPtr = ptr;

	if(m_textPtr != 0)
	{
		m_textPtr->Farbe = m_farbe;
		m_textPtr->Inhalt = m_text.c_str();
		m_textPtr->X = m_x;
		m_textPtr->Y = m_y;
	}
}

///////////////////////////////////////////////////////////

void Text::setzeText(const string& text)
{
	m_text = text;

	if(m_textPtr != 0)
	{
		try
		{
			m_textPtr->Inhalt = m_text.c_str();
		}
		catch(_com_error&)
		{
		}
	}
}

///////////////////////////////////////////////////////////
