#include "Notenliste.h"
#include <iostream>

using namespace std;

Notenliste::Notenliste(const std::string& courseName)
                 :_courseName(courseName)
{
}

void Notenliste::add(const Note& note)
{
    _noten.push_back(note);
}

void Notenliste::toConsole(Note::Round round) const
{
    cout << endl;
    cout << "Noteliste fuer das Fach " << _courseName;
    cout << endl;

    // direkt initialiseren
    Noten::const_iterator it = _noten.begin();
    // damit nicht stndig end() aufgerufen
    // wird -> schneller als Glenn!
    Noten::const_iterator end = _noten.end();

    for(/*no init*/ ; it != end; ++it)
    {
        const Note& note = *it;
        note.writeToConsole(round);
        cout << endl;
    }

    Note schnitt = average();
    cout << "Durchschnitt : ";
    schnitt.writeToConsole(round);
    cout << endl;
}

Note Notenliste::average() const
{
    Note result(2.0);

    if(!_noten.empty())
    {
        // direkt initialiseren
        Noten::const_iterator it = _noten.begin();
        // damit nicht stndig end() aufgerufen
        // wird -> schneller als Glenn!
        Noten::const_iterator end = _noten.end();

        double sum = 0.0;

        for(/*no init*/ ; it != end; ++it)
        {
            const Note& note = *it;
            sum += note.getValue();
        }

        double av = sum / _noten.size();

        result.setValue(av);
    }
    return result;
}

void Notenliste::fillFromConsole()
{
    std::string eingabe = "j";

    while(eingabe == "j")
    {
        Note neueNote;
        neueNote.readFromConsole();
        cout << " weiter [j/n] ";
        cin >> eingabe;
        add(neueNote);
    }
}

