#pragma warning (disable : 4786)

#include "Singleton.h"

#include <map>
#include <iostream>
#include <string>


/* TEST1
int main()
{
    Singleton& test1 = Singleton::getSingleton(1);
    test1.doIt();

    Singleton& test2 = Singleton::getSingleton(2);
    test2.doIt();

    Singleton& test3 = Singleton::getSingleton(1);
    test3.doIt();

    return 0;
}*/


// TEST2
#include "Person.h"

int main()
{
    Persons thePersons;

    // hier erzeugen wir ein std::pair-Objekt
    // mit dem Namen eintrag1. Dieses Objekt
    // nimmt als Konstruktor-Argument einen KeyType also
    // ein string und ein ElementType also ein Person-Objekt
    // Beachte, dass zum Erstellen des Person-Objektes
    // die Konstruktor-Argumente anzugeben sind.
    std::pair<std::string, Person> eintrag1("Markus", Person("Markus", "Burri"));

    thePersons.insert(eintrag1);

    // Das pair-Objekt wird autoamtisch als typedef definiert
    // wir knnen also das gleiche wie oben auf diese Art erreichen
    Persons::value_type eintrag2("Fred", Person("Fred", "Feuerstein"));

    thePersons.insert(eintrag2);

    // Am einfachsten ist das einfgen mit dem index-Operator
    thePersons["Bart"] = Person("Bart", "Simpson");

    // Zugriff ber find
    Persons::iterator it = thePersons.find("Markus");
    if(it != thePersons.end())
    {
        // gefunden !
        Person& markusPerson = it->second;
    }

    // oder mit Index-Operator
    Person& bartPerson = thePersons["Bart"];

    return 0;
}