#ifndef SINGLETON_H
#define SINGLETON_H

#include <map>

// Vorwrtsdeklaration damit wir die
// map definieren knnen
class Singleton;

// typedef fr eine map mir einem unsigned char
// als Schlssel und einem Singleton-Objekt
// als Element
typedef std::map<unsigned char, Singleton> Singletons;

class Singleton
{
public:
    void doIt() const;
    ~Singleton();

    // angepasste get-Methode
    static Singleton& getSingleton(unsigned char port);

private:
    // Die map, die wir erzeugt haben
    // muss den Standardkonstruktor aufrufen
    // knnen, der aber privat ist.
    // Wir machen darum die map zum Freund!
    friend Singletons;

    Singleton();
    void open(unsigned char port);
};


#endif