
// Der Compiler erzeugt zum Teil zu lange
// interne Bezeichner, was zu einer Warnung
// fhrt. Diese schalten wir mit pragma ab.
#pragma warning (disable : 4786)

#include "Singleton.h"
#include <iostream>

Singleton::Singleton()
{
}

Singleton& Singleton::getSingleton(unsigned char port)
{
    // Diese Variable (also map) wird nur einmal
    // erzeugt und bleibt dann immer vorhanden
    static Singletons dieSingletons;
    
    // Wir sehen ob das Objekt bereits existiert
    Singletons::iterator it = dieSingletons.find(port);

    if(it == dieSingletons.end())
    {
        // Das Obekt existiert noch nicht, wir
        // erzeugen es jetzt also mit dem Index-Operator
        Singleton& neuesObjekt = dieSingletons[port];
        // und rufen eine Methode davon auf
        neuesObjekt.open(port);
    }

    return dieSingletons[port];
}

void Singleton::doIt() const
{
}

void Singleton::open(unsigned char port)
{
}

Singleton::~Singleton()
{
}