// NotenverwaltungView.cpp : implementation of the CNotenverwaltungView class
//

#include "stdafx.h"
#include "Notenverwaltung.h"

#include "NotenverwaltungDoc.h"
#include "NotenverwaltungView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungView

IMPLEMENT_DYNCREATE(CNotenverwaltungView, CListView)

BEGIN_MESSAGE_MAP(CNotenverwaltungView, CListView)
	//{{AFX_MSG_MAP(CNotenverwaltungView)
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CListView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CListView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CListView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungView construction/destruction

CNotenverwaltungView::CNotenverwaltungView()
{
}

CNotenverwaltungView::~CNotenverwaltungView()
{
}

BOOL CNotenverwaltungView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CListView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungView drawing

void CNotenverwaltungView::OnDraw(CDC* pDC)
{
	CNotenverwaltungDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	CListCtrl& refCtrl = GetListCtrl();
	refCtrl.InsertItem(0, "Item!");
}

void CNotenverwaltungView::OnInitialUpdate()
{
	CListView::OnInitialUpdate();

}

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungView printing

BOOL CNotenverwaltungView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CNotenverwaltungView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

void CNotenverwaltungView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungView diagnostics

#ifdef _DEBUG
void CNotenverwaltungView::AssertValid() const
{
	CListView::AssertValid();
}

void CNotenverwaltungView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}

CNotenverwaltungDoc* CNotenverwaltungView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CNotenverwaltungDoc)));
	return (CNotenverwaltungDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungView message handlers
void CNotenverwaltungView::OnStyleChanged(int nStyleType, LPSTYLESTRUCT lpStyleStruct)
{
}

void CNotenverwaltungView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	// TODO: Add your message handler code here
	
}

void CNotenverwaltungView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
    CListCtrl& listCtrl = GetListCtrl();
    listCtrl.DeleteAllItems();
    CHeaderCtrl* headerCtrl = listCtrl.GetHeaderCtrl();
    if(headerCtrl)
    {
        int columnCount = headerCtrl->GetItemCount();
        for(int columnIndex = 0; columnIndex < columnCount; ++columnIndex)
        {
            listCtrl.DeleteColumn(0);
        }
    }
	CNotenverwaltungDoc* document = GetDocument();
    CString aktuellesFach = document->getAktuellesFach();

    if(aktuellesFach.IsEmpty())
    {
        listCtrl.InsertColumn(0, "Fach", LVCFMT_LEFT, 60, 0);
        listCtrl.InsertColumn(1, "Lehrer", LVCFMT_LEFT, 60, 1);
        listCtrl.InsertColumn(0, "Durchschnitt", LVCFMT_LEFT, 110, 2);
    }
    else
    {
        listCtrl.InsertColumn(0, aktuellesFach, LVCFMT_LEFT, 100);
    }
}
