// NotenverwaltungDoc.cpp : implementation of the CNotenverwaltungDoc class
//

#include "stdafx.h"
#include "Notenverwaltung.h"
#include "NeuesFachDialog.h"
#include "NotenverwaltungDoc.h"
#include "Fach.h"
#include "FachObserver.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungDoc

IMPLEMENT_DYNCREATE(CNotenverwaltungDoc, CDocument)

BEGIN_MESSAGE_MAP(CNotenverwaltungDoc, CDocument)
	//{{AFX_MSG_MAP(CNotenverwaltungDoc)
	ON_COMMAND(IDM_NEUESFACH, OnBearbeitenNeuesfacherzeugen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungDoc construction/destruction

CNotenverwaltungDoc::CNotenverwaltungDoc()
{
}

CNotenverwaltungDoc::~CNotenverwaltungDoc()
{
}

BOOL CNotenverwaltungDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungDoc serialization

void CNotenverwaltungDoc::Serialize(CArchive& ar)
{
    _faecher.Serialize(ar);
	if (ar.IsStoring())
	{
        ar << _aktuellesFach;
	}
	else
	{
        ar >> _aktuellesFach;
        
        CStringArray fachNamen;
        fillFachArray(fachNamen);
        FachObservers::iterator it = _fachObservers.begin();
        FachObservers::iterator end = _fachObservers.end();
        for( ; it != end; ++it)
        {
            FachObserver* observer = *it;
            observer->onNeueFaecher(fachNamen);
            observer->onNeuesAktuellesFach(_aktuellesFach);
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungDoc diagnostics

#ifdef _DEBUG
void CNotenverwaltungDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CNotenverwaltungDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CNotenverwaltungDoc commands

CString CNotenverwaltungDoc::getAktuellesFach() const
{
    return _aktuellesFach;
}

void CNotenverwaltungDoc::setAktuellesFach(const CString &fachname)
{
    _aktuellesFach = fachname;
    UpdateAllViews(0);

    FachObservers::iterator it = _fachObservers.begin();
    FachObservers::iterator end = _fachObservers.end();
    for( ; it != end; ++it)
    {
        FachObserver* observer = *it;
        observer->onNeuesAktuellesFach(_aktuellesFach);
    }
}

void CNotenverwaltungDoc::OnBearbeitenNeuesfacherzeugen() 
{
    CNeuesFachDialog dlg;
    if(IDOK == dlg.DoModal())
    {
        CString fachname = dlg.getFachname();
        if(0 != fachname.GetLength())
        {
            CString lehrername = dlg.getLehrername();
            _faecher.neuesFach(fachname, lehrername);
            // das neue Fach wird auch gleich
            // zum aktuellen Fach
            _aktuellesFach = fachname;
            // Views ber die nderungen 
            // benachrichtigen
            UpdateAllViews(0);

            FachObservers::iterator it = _fachObservers.begin();
            FachObservers::iterator end = _fachObservers.end();
            for( ; it != end; ++it)
            {
                FachObserver* observer = *it;
                observer->onNeuesFach(_aktuellesFach);
                observer->onNeuesAktuellesFach(_aktuellesFach);
            }
        }
    }
}

void CNotenverwaltungDoc::fillFachArray(CStringArray& fachnamen)
{
    _faecher.fillFachArray(fachnamen);
}
///////////////////////////

void CNotenverwaltungDoc::addFachObserver(FachObserver* observer)
{
    _fachObservers.insert(observer);
}

void CNotenverwaltungDoc::removeFachObserver(FachObserver* observer)
{
    _fachObservers.erase(observer);
}
