
#include <iostream>
#include <vector>
#include <string>

// Kleine Klasse Test 
// mit einer virtuellen
// Methode ausgeben
class Test
{
public:
    Test(const std::string& text1,
             const std::string& text2)
             :_text1(text1), _text2(text2)
    {
    }

    virtual void ausgeben()
    {
        std::cout << _text1 << std::endl;
        std::cout << _text2 << std::endl;
    }

private:
    std::string _text1;
    std::string _text2;
};

// Die Klasse TestTest berschreibt
// die Methode ausgeben der 
// Basisklasse Test
class TestTest : public Test
{
public:
    TestTest(const std::string& text1,
                    const std::string& text2,
                    const std::string& text3)
                    :Test(text1, text2), _text3(text3)
    {
    }

    virtual void ausgeben()
    {
        // Methode der Basisklasse
        // aufrufen
        Test::ausgeben();
        std::cout << _text3 << std::endl;
    }
private:
    std::string _text3;
};

// damit Polymorphismus funktioniert
// sollten sich im Container nur Zeiger
// befinden, andernfall werden Objekte
// erzeugt, die vom Datentypen im
// Container sind.
typedef std::vector<Test*> Tests;

int main()
{
    Tests meineTests;

    // Wir erzeugen hier
    // ein Objekt auf dem Stack
    // In euren Beispielen wrdet
    // Ihr die Objekte auf dem Heap
    // mit new erzeugen!
    Test einTest("1","1");
    einTest.ausgeben();
    // in den Container fllen
    // wir hier die die Adresse
    // der Objekte ein.
    meineTests.push_back(&einTest);
    TestTest zweiterTest("2", "2", "666");
    zweiterTest.ausgeben();
    meineTests.push_back(&zweiterTest);

    Tests::iterator it = meineTests.begin();
    Tests::iterator end = meineTests.end();

    for( ; it != end; ++it)
    {
        // Der iterator ist vom Datentyp
        // her ein Zeiger auf den Inhalt
        // des Containers, hier also ein 
        // Zeiger auf Test Objekte.
        Test* test = *it;
        // ber den Zeiger wird nun
        // die virtuelle Methode
        // aufgerufen
        test->ausgeben();
    }

    return 0;
}
