#pragma warning(disable : 4786)
#include <iostream>
#include <string>
#include <map>
#include <crtdbg.h>
class Buch
{
public:
    Buch() 
    {
    }
    Buch(const std::string& titel,
             const std::string& autor)
             :_titel(titel), _autor(autor)
    {
    }
    bool operator==(const Buch& anderesBuch)
    {
        if(_titel == anderesBuch._titel &&
            _autor == anderesBuch._autor)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    void ausgeben() const
    {
        std::cout << "Titel : " << _titel;
        std::cout << " Autor : " << _autor;
    }
    void aendereTitel(const std::string& neuerTitel)
    {
        _titel = neuerTitel;
    }
private:
    std::string _titel;
    std::string _autor;
};

typedef long ISBN;

typedef std::map<ISBN, Buch> Buchkatalog;

int main()
{
    ISBN isbn1 = 444;
    ISBN isbn2 = 555;
    ISBN isbn3 = 777;
    Buch buch1("C++", "Prinz");
    Buch buch2("Mathe", "Fred");
    Buchkatalog katalog;

    katalog[isbn1] = buch1;
    katalog[isbn2] = buch2;

    Buch& test = katalog[isbn1];
    _ASSERT(test == buch1);

    if(katalog.find(isbn3) == katalog.end())
    {
        std::cout << "Element nicht gefunden" << std::endl;
    }
    else
    {
        std::cout << isbn3 << " gefunden";
    }

    Buch drittesBuch("Roman", "Sepp");
    Buchkatalog::value_type element(isbn3, drittesBuch);
    katalog.insert(element);

    ISBN isbnTest = element.first;
    Buch buchTest = element.second;


    if(katalog.find(isbn3) != katalog.end())
    {
        Buchkatalog::iterator it = katalog.find(isbn3);
        Buch buch = it->second;
        buch.aendereTitel("Test");
    }
    else
    {
        std::cout << isbn3 << " nicht gefunden";
    }

    Buchkatalog::iterator it = katalog.begin();
    Buchkatalog::iterator end = katalog.end();

    for( ; it != end; ++it)
    {
        ISBN isbn = it->first;
        Buch& buch = it->second;
        std::cout << isbn << " : ";
        buch.ausgeben();
        std::cout << std::endl;
        /*
        Buchkatalog::value_type paar = *it;
        ISBN isbn = paar.first;
        Buch buch = paar.second;
        std::cout << isbn << " : ";
        buch.ausgeben();
        std::cout << std::endl;*/
    }
    return 0;
};