
#include <list>
#include <string>
#include <iostream>

class Person
{
public:
    Person(const std::string& vorname,
           const std::string& nachname)
           :_vorname(vorname), 
            _nachname(nachname)
    {
    }

    void ausgeben(std::ostream& out) const
    {
        out << _vorname << " ";
        out << _nachname << std::endl;
    }

    static bool vergleiche(Person* p1, Person* p2)
    {
        if(p1->_nachname == p2->_nachname)
        {
            return (p1->_vorname < p2->_vorname);
        }
        else
        {
            return p1->_nachname < p2->_nachname;
        }
    }

private:
    std::string _vorname;
    std::string _nachname;
};


// neuen Datentypen definieren
// hier nur Zeiger verwalten
typedef std::list<Person*> Personen;

int main()
{
    Person* einePerson = new Person("Hans", "Zwahlen");
    Person* zweitePerson = new Person("Markus", "Burri");

    Personen allePersonen;

    allePersonen.push_back(einePerson);
    allePersonen.push_back(zweitePerson);

    // Sortiere mit Hilfe der
    // statischen vergleiche Methode
    allePersonen.sort(Person::vergleiche);

    // Schleife zum Ausgeben aller 
    // Elemente.
    Personen::iterator it = allePersonen.begin();
    Personen::iterator end = allePersonen.end();
    for( ; it != end; ++it)
    {
        Person* person = *it;
        person->ausgeben(std::cout);
    }

    // Schleife zum Lschen aller 
    // Elemente.
    it = allePersonen.begin();

    for( ; it != end; ++it)
    {
        Person* person = *it;
        delete person;
    }

    return 0;
}

