
#include <vector>
#include <list>
#include <crtdbg.h>
#include <iostream>


// Datentypen definieren
typedef std::vector<double> DoubleVector;
typedef std::list<long> LongList;

void fillDoubleVector(DoubleVector& vector)
{
    for(long i = 0; i < 23; ++i)
    {
        vector.push_back(double(i) / 4.5);
    }
}

void fillLongList(LongList& list)
{
    for(long i = 0; i < 23; ++i)
    {
        list.push_back(i * 22);
    }
}

/*
int main()
{
    long daten[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };

    // dieser Zeiger zeigt nun
    // auf das erste Element
    long* iterator = daten;

    // lnge berechnen
    long size = sizeof(daten) / sizeof(daten[0]);
    // Zeiger end hinter das letzte Element
    // zeigen lassen
    long* end = iterator + size;
    while(iterator != end)
    {
        // Wert holen, indem
        // man den Zeiger dereferenziert
        long wert = *iterator;
        std::cout << wert << std::endl;
        ++iterator;
    }

    return 0;
}
*/

int main()
{
    DoubleVector doubleVector;
    LongList longList;

    // Elemente hinten anfgen
    doubleVector.push_back(4.5);
    longList.push_back(5675);

    // size_type entspricht einem long
    // dieses size_type wurde per typedef
    // in der jeweiligen Klasse definiert
    // darum der Zugriff mit ::
    DoubleVector::size_type vectorLength = doubleVector.size();
    LongList::size_type listLength = longList.size();

    // da je ein Element eingefgt wurde
    // mssen beide container die 
    // Lnge 1 haben.
    _ASSERT(1 == vectorLength);
    _ASSERT(1 == listLength);

    // letzte Elemente lschen
    doubleVector.pop_back();
    longList.pop_back();

    // Funktion aufrufen, die einige
    // Elemente einfgt
    fillDoubleVector(doubleVector);
    // Anzahl Element finden
    vectorLength = doubleVector.size();
    // Schleife
    for(unsigned long i = 0; i < vectorLength; ++i)
    {
        std::cout << doubleVector[i] << std::endl;
    }

    fillLongList(longList);

    // hier eine while-Schleife zum Iterieren
    DoubleVector::iterator it1 = doubleVector.begin();
    DoubleVector::iterator end1 = doubleVector.end();
    while(it1 != end1)
    {
        double d = *it1;
        std::cout << d << std::endl;
        ++it1;
    }


    // Hier das gleich als for-Schleife
    for(LongList::iterator it2 = longList.begin();
        it2 != longList.end(); ++it2)
    {
        // hier holen wir uns nur
        // eine Referenz
        long& l = *it2;
        std::cout << l << std::endl;
    }

    // so wie ich das immer mache
    DoubleVector::iterator it = doubleVector.begin();
    DoubleVector::iterator end = doubleVector.end();

    for( ; it != end; ++it)
    {
        double& d = *it;
        std::cout << d << std::endl;
    }

    LongList::iterator elementIt = longList.begin();
    // auf zweites Element vorrcken
    ++elementIt;
    // Dieses Element lschen
    longList.erase(elementIt);

    unsigned long index = 4;
    // stelle sicher, dass mindestens
    // fnf Elemente im vector sind
    _ASSERT(index < doubleVector.size());
    double& el4 = doubleVector[index];

    longList.sort();
       
    return 0;
}

