#include <iostream>
#include <cmath>
#include "Console.h"

using namespace std;

const double PI = 3.1415926536;
const double START = 0.0;
const double ENDE = 2.0 * PI;

const int PKT = 64;
const double SCHRITT = (ENDE - START) / PKT;
const int xA = 14;
const int yA = 10;

int main()
{
    // Das KonsolenFenster
    Console KonsolenFenster;

    int zeile = 0;
    int spalte = 0;

    KonsolenFenster.Clear();

    KonsolenFenster.Locate(2, 25);

    cout << "----- Die Sinus-Funktion ----";

    // Koordinaten-Kreuz zeichnen
    KonsolenFenster.Locate(xA, 1);
    for(spalte = 1; spalte < 78; ++spalte)
    {
        // bei jedem achten mal wird ein plus anstatt
        // einer linie ausgegeben
        if(0 == (spalte-yA) % 8)
        {
            cout << '\305';
        }
        else
        {
            cout << '\304';
        }
    }
    // Spitze
    cout << '\020';

    KonsolenFenster.Locate(xA-1, yA+64);

    cout << "2PI x";

    // y - achse
    for(zeile = 5; zeile < 24; ++zeile)
    {
        KonsolenFenster.Locate(zeile, yA);
        cout << '\305';
    }
    // Spitze

    KonsolenFenster.Locate(4, yA);
    cout << '\036' << " sin(x)";

    KonsolenFenster.Locate(xA-8, yA+1);
    cout << " 1";

    KonsolenFenster.Locate(xA+8, yA+1);
    cout << " -1";

    // Sinus Funktion aufgeben

    int anfsp = yA;
    int endsp = anfsp + PKT;

    for(spalte = anfsp; spalte <= endsp; ++spalte)
    {
        double x = (spalte-yA) * SCHRITT;
        double sinus = sin(x);
        zeile = xA - (8.0 * sinus) + 0.5;
        KonsolenFenster.Locate(zeile, spalte);
        cout << '*';
    }

    KonsolenFenster.Locate(25,1);

    return 0;
}