
class Rad
{
    public:
        // Konstruktor mit Parametern
        Rad(long radius);

        static long holeAnzahlRaeder();

    private:
        long         m_radius;
        const double m_pi;
        // diese Zahl gibt es
        // nur einmal, unabhngig
        // der Anzahl Rder die
        // erzeugt werden
        static long  s_anzahlRaeder;
};

long Rad::s_anzahlRaeder = 0;

long Rad::holeAnzahlRaeder()
{
    return s_anzahlRaeder;
}

Rad::Rad(long radius)
    :m_pi(3.1415)
{
    m_radius = radius;
    // Gesamtanzahl der Rder
    // erhhen
    s_anzahlRaeder++;
}


class Auto
{
    public:
        // Konstruktor
        Auto();

        // weitere Methoden
    private:
        // Teilobjekte
        Rad     m_linkesVorderrad;
        Rad     m_rechtesVorderrad;
        Rad     m_linkesHinterrad;
        Rad     m_rechtesHinterrad;
};

Auto::Auto()
     :m_linkesVorderrad(4),
      m_rechtesVorderrad(4),
      m_linkesHinterrad(4),
      m_rechtesHinterrad(4)
{
}

int main()
{
    long radius = 6;

    Rad einRad(radius);
    Rad einZweitesRad(radius);

    // statische Methode aufrufen
    long anzahl = Rad::holeAnzahlRaeder();
    // oder wenn es ein Objekt gibt
    anzahl = einRad.holeAnzahlRaeder();

    return 0;
}