// Anwenden von iostream Klassen
// Kleines main.cpp zum testen des Schreibens
// und Lesens mit getline

#include <string>
#include <iostream>
#include <fstream>

using namespace std;

class CD
{
    public:
        CD();

        void writeToStream(ostream& out);
        void readFromStream(istream& in);

    private:
        string m_title;
        double m_length;
        string m_interpret;
};

CD::CD()
{
    m_title = "test";
    m_interpret = "Fred Feuerstein";
    m_length = 35.77;
}

void CD::writeToStream(ostream& out)
{
    out << m_title << "\t";
    out << m_interpret << "\t";
    out << m_length << endl;
}

void CD::readFromStream(istream& in)
{
    getline(in, m_title, '\t');
    getline(in, m_interpret, '\t');
    in >> m_length;
}

const char* fileName = "c:\\cd.txt";

int main()
{
    CD cd1;
    CD cd2;

    // Ausgabe auf den Bildschirm
    cd1.writeToStream(cout);
    cd2.writeToStream(cout);

    // Ausgabe in eine Datei
    ofstream fout(fileName);
    cd1.writeToStream(fout);
    cd2.writeToStream(fout);

    // Die Datei muss geschlossen
    // werden, sonst kann sie
    // unten nicht mehr geffnet
    // werden
    fout.close();

    // Aus der Datei wieder lesen
    ifstream in(fileName);
    cd1.readFromStream(in);
    cd2.readFromStream(in);

    return 0;
}