#include "CD.h"     // Die CD-Klasse
#include "CDList.h" // Die CDList-Klasse

#include <conio.h>  // fr das getch
#include <crtdbg.h> // fr die _CrtSetDbgFlag
                    // Funktion
#include <iostream> // fr cin, cout
#include <string>   // fr die strings

using namespace std;

int main()
{
    // Dieser Funktionsaufruf bewirkt, dass beim
    // Beenden des Programms Speicherlecks angezeigt
    // werden.
    _CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);

    int weiter = 'j';   
    // Der Datentyp fr die Variable "weiter" msste
    // eigentlich char sein, aber die Funktion
    // getch liefert den ASCII-Wert der gedrckten
    // Taste als int zurck.

    // Ich verwende fr alle CD's die gleichen Daten
    string ElvisName("Elvis");
    string ElvisTitle("Viva Las Vegas");
    double Laenge = 36.0;

    // Neue Liste auf dem Stack-Speicher anlegen
    CDList theList;

    while(weiter == 'j')
    {
        // neue CD auf dem Heap-Speicher anlegen
        CD* pCD = new CD;

        pCD->SetInterpret(ElvisName);
        pCD->SetTitle(ElvisTitle);
        pCD->SetLength(Laenge);

        // Einfach diese CD in die Liste einfgen
        theList.AddNewCD(pCD);

        cout << "Noch eine CD ? [j/n]" << endl;

        weiter = getch();
    }

    CD* actual = theList.GetFirst();

    while(actual != theList.GetLast())
    {
        CD* toDelete = actual;
        actual = toDelete->GetNext();
        delete toDelete;
    }
    delete actual;

    return 0;
}