

#include <windows.h>
#include <string>
#include <iostream>

using namespace std;

struct ThreadData
{
    HANDLE stopEvent;
    string     data;
    ThreadData() : stopEvent(0)
    {
    }
};

DWORD WINAPI ThreadFunc(LPVOID param)
{
    ThreadData* threadData = (ThreadData*)param;

    while(1)
    {
        DWORD wait = 0;
        wait = WaitForSingleObject(threadData->stopEvent, 600);
        if(WAIT_TIMEOUT == wait)
        {
            cout << threadData->data << endl;
        }
        else
        {
            break;
        }
    }

    return 69;
}

int main()
{
    ThreadData* threadData = new ThreadData;
    threadData->data = "Hallo Thread";
    threadData->stopEvent = CreateEvent(0,
                                                                FALSE,
                                                                FALSE,
                                                                "StopEvent");
    DWORD threadId = 0;
    HANDLE h = CreateThread(0, // keine Security
                                             0, // normale Stackgrsse
                                             ThreadFunc,
                                             (void*)threadData,
                                             0,
                                             &threadId);

    for(int i = 0; i < 8; ++i)
    {
        cout << "Main Thread" << endl;
        Sleep(1000);
    }

    SetEvent(threadData->stopEvent);

    DWORD startWait = GetTickCount();
    DWORD wait = WaitForSingleObject(h, INFINITE);
    DWORD diff = GetTickCount() - startWait;

    cout << "Wartezeit : " << diff << " ms" << endl;

    delete threadData;

    return 0;
}