
#include <fstream>

#include <vector>
#include <crtdbg.h> // fr ASSERT

typedef double Parameter;

class Function
{
public:
    // Konstruktor
    Function(int parameterCount)
    {
        // Vector vergrssern
        // und Werte initialisieren
        _parameters.resize(parameterCount, 0);
    }

    Parameter& operator[] (unsigned int index)
    {
        // Grenzen prfen
        _ASSERT(index < _parameters.size());
        return _parameters[index];
    }
private:
    std::vector<Parameter> _parameters;
};

class Channel
{
public:
    Channel(int functionCount, int parameterCount)
    {
        _functions.resize(functionCount, parameterCount);
    }

    Function& operator[] (unsigned int index)
    {
        _ASSERT(index < _functions.size());
        return _functions[index];
    }

private:
    std::vector<Function> _functions;
};

class Mixer
{
public:
    Mixer(int channelCount,
          int functionCount,
          int parameterCount)
    {
        for(int i = 0; i < channelCount; ++i)
        {
            Channel* channel = new Channel(functionCount, 
                                           parameterCount);
            _channels.push_back(channel);
        }
    }

    ~Mixer()
    {
        const size_t count = _channels.size();
        for(unsigned long i = 0; i < count; ++i)
        {
            Channel* channel = _channels[i];
            delete channel;
        }
    }

    Channel& operator[](unsigned int index)
    {
        _ASSERT(index < _channels.size());
        return *_channels[index];
    }
private:
    std::vector<Channel*> _channels;
};

int main()
{
    // Konfigurationsdaten auslesen
    std::ifstream config("config.txt");

    // Anzahl Kanle
    int channelCount = 0;
    config >> channelCount;

    // Anzahl Funktionen
    int functionCount = 0;
    config >> functionCount;

    // Anzahl Parameter
    int parameterCount = 0;
    config >> parameterCount;

    Mixer meinMixer(channelCount, functionCount, parameterCount);

    meinMixer[0][2][4] = 3.5;

    double test = meinMixer[0][2][4];

    // schner:
    Channel& channel = meinMixer[0];
    Function& function = channel[2];
    Parameter& parameter = function[4];

    test = parameter;

    return 0;
}