
#include <fstream>

int main()
{
    // dynamisches dreidimensionales Array
    double*** data = 0;

    // Konfigurationsdaten auslesen
    std::ifstream config("config.txt");

    // Anzahl Kanle
    int channelCount = 0;
    config >> channelCount;

    // Anzahl Funktionen
    int functionCount = 0;
    config >> functionCount;

    // Anzahl Parameter
    int parameterCount = 0;
    config >> parameterCount;

    // Kanle erzeugen
    data = new double**[channelCount];

    // Funktionen erzeugen
    for(int channelIndex = 0; 
        channelIndex < channelCount;
        ++channelIndex)
    {
        data[channelIndex] = new double*[functionCount];
        // Parameter erzeugen
        for(int functionIndex = 0;
            functionIndex < functionCount;
            ++functionIndex)
        {
            data[channelIndex][functionIndex] = new double[parameterCount];
        }
    }

    // Zugriff auf Channel 0, Function 2, Parameter 4 
    data[0][2][4] = 3.5;

    double test = data[0][2][4];

    // Freigeben des Speichers
    for(channelIndex = 0;
        channelIndex < channelCount;
        ++channelIndex)
    {
        for(int functionIndex = 0;
            functionIndex < functionCount;
            ++functionIndex)
        {
            delete [] data[channelIndex][functionIndex];
        }
        delete [] data[channelIndex];
    }
    delete [] data;

    return 0;
}