#include <windows.h>

// Das Betriebssystem braucht eine Funktion, die es
// aufrufen kann, wenn irgendwelche Ereignisse
// (Maus, Tasten, etc.) fr das Fenster eintreffen
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);


// Das ist die main-Funktion von einem normalen
// Win32 Programm (also nicht Console)
int APIENTRY WinMain(HINSTANCE hInstance,       // Jede Applikation ist ber
                     HINSTANCE notUsed,         // ein Handle (HINSTANCE) identifiziert
                     LPSTR     lpCmdLine,       // Kommandozeilenargumente
                     int       nCmdShow)        // Gibt an, on das Fenster gezeigt werden
{                                               // soll

    WNDCLASS wc = {0};                          // Struktur fr Window-Information

    wc.hInstance = hInstance;                   // Handle der Applikation
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);// Hintergrundfarbe fr das Fenster
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);   // Maus-Cursor gltig fr das Fenster
    wc.lpszClassName = "MyFirstWindowCls";      // Name fr diese Window-Class
    wc.lpfnWndProc = WindowProcedure;           // Window-Bearbeitungsfunktion

    if(RegisterClass(&wc))                      // Die Window-Class registrieren
    {
        HWND hwnd = CreateWindow("MyFirstWindowCls", // Window-Class Name
                                 "Markus",      // Fenstername
                                 WS_VISIBLE | WS_OVERLAPPEDWINDOW, // Fenster-Stil
                                 10,            // x
                                 10,            // y
                                 400,           // breite
                                 300,           // hoehe
                                 NULL,          // Eltern-Fenster (NULL > Toplevel)
                                 NULL,          // Handle fr ein Menu (NULL > keins)
                                 hInstance,     // Applikations-Handle
                                 NULL);         // Zeiger auf Daten, die der Fensterprozedur
    }                                           // bergeben wird

    // Main message loop:
    MSG msg = { 0 };
    // GetMessage wartet auf eine Nachricht
    // Falls die Nachricht die WM_QUIT-Nachricht ist
    // gibt GetMessage 0 zurck und die Schleife wird
    // verlassen.
    while (GetMessage(&msg, NULL, 0, 0)) 
    {
        // Mit DispatchMessage werden die Nachrichten
        // (Messages) auf die Fensterfunktionen verteilt
	    DispatchMessage(&msg);
    }

	return 0;
}


LRESULT CALLBACK WindowProcedure(HWND hWnd, // Handle des Fensters fr welches die Nachricht ist 
                                 UINT message,  // Nachrichtencode (z.B. WM_SHOW etc.)
                                 WPARAM wParam, // zustzliche Infos zu den Nachrichten
                                 LPARAM lParam)
{
    switch(message)
    {
        case WM_DESTROY:
            // Das Fenster wird geschlossen
            PostQuitMessage(0); // Die WM_QUIT Nachricht wird erzeugt (siehe oben bei GetMessage)
        break;
        default:
            // Diese Funktion verarbeitet die Nachricht auf Standard-Art
            return DefWindowProc(hWnd, message, wParam, lParam);

    }

    return 0;
}

